% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVP.FarmCPU.r
\name{MVP.FarmCPU}
\alias{MVP.FarmCPU}
\title{Perform GWAS using FarmCPU method}
\usage{
MVP.FarmCPU(phe, geno, map, CV = NULL, P = NULL,
  method.sub = "reward", method.sub.final = "reward",
  method.bin = c("EMMA", "static", "FaST-LMM"), bin.size = c(5e+05,
  5e+06, 5e+07), bin.selection = seq(10, 100, 10),
  memo = "MVP.FarmCPU", Prior = NULL, ncpus = 2, maxLoop = 10,
  threshold.output = 0.01, converge = 1, iteration.output = FALSE,
  p.threshold = NA, QTN.threshold = 0.01, bound = NULL,
  verbose = TRUE)
}
\arguments{
\item{phe}{phenotype, n by t matrix, n is sample size, t is number of phenotypes}

\item{geno}{genotype, m by n matrix, m is marker size, n is sample size. This is Pure Genotype Data Matrix(GD). THERE IS NO COLUMN FOR TAXA.}

\item{map}{SNP map information, m by 3 matrix, m is marker size, the three columns are SNP_ID, Chr, and Pos}

\item{CV}{covariates, n by c matrix, n is sample size, c is number of covariates}

\item{P}{start p values for all SNPs}

\item{method.sub}{method used in substitution process, five options: 'penalty', 'reward', 'mean', 'median', or 'onsite'}

\item{method.sub.final}{method used in substitution process, five options: 'penalty', 'reward', 'mean', 'median', or 'onsite'}

\item{method.bin}{method for selecting the most appropriate bins, three options: 'static', 'EMMA' or 'FaST-LMM'}

\item{bin.size}{bin sizes for all iterations, a vector, the bin size is always from large to small}

\item{bin.selection}{number of selected bins in each iteration, a vector}

\item{memo}{a marker on output file name}

\item{Prior}{prior information, four columns, which are SNP_ID, Chr, Pos, P-value}

\item{ncpus}{number of threads used for parallele computation}

\item{maxLoop}{maximum number of iterations}

\item{threshold.output}{only the GWAS results with p-values lower than threshold.output will be output}

\item{converge}{a number, 0 to 1, if selected pseudo QTNs in the last and the second last iterations have a certain probality (the probability is converge) of overlap, the loop will stop}

\item{iteration.output}{whether to output results of all iterations}

\item{p.threshold}{if all p values generated in the first iteration are bigger than p.threshold, FarmCPU stops}

\item{QTN.threshold}{in second and later iterations, only SNPs with lower p-values than QTN.threshold have chances to be selected as pseudo QTNs}

\item{bound}{maximum number of SNPs selected as pseudo QTNs in each iteration}

\item{verbose}{whether to print detail.}
}
\value{
a m by 4 results matrix, m is marker size, the four columns are SNP_ID, Chr, Pos, and p-value
}
\description{
Date build: Febuary 24, 2013
Last update: May 25, 2017
Requirement: Y, GD, and CV should have same taxa order. GD and GM should have the same order on SNPs
}
\examples{
phePath <- system.file("extdata", "07_other", "mvp.phe", package = "rMVP")
phenotype <- read.table(phePath, header=TRUE)
idx <- !is.na(phenotype[, 2])
phenotype <- phenotype[idx, ]
print(dim(phenotype))
genoPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.desc", package = "rMVP")
genotype <- attach.big.matrix(genoPath)
genotype <- deepcopy(genotype, cols=idx)
print(dim(genotype))
mapPath <- system.file("extdata", "06_mvp-impute", "mvp.imp.geno.map", package = "rMVP")
map <- read.table(mapPath , head = TRUE)

farmcpu <- MVP.FarmCPU(phe=phenotype,geno=genotype,map=map,maxLoop=2,method.bin="static")
str(farmcpu)

}
\author{
Xiaolei Liu and Zhiwu Zhang
}
