% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenceOperator.R
\name{SequenceOperator}
\alias{SequenceOperator}
\title{Create a Sequence Operator for Sequence-Based Searches}
\usage{
SequenceOperator(
  sequence,
  sequence_type = NULL,
  evalue_cutoff = 100,
  identity_cutoff = 0.95
)
}
\arguments{
\item{sequence}{A string representing the sequence to search for.}

\item{sequence_type}{Optional: a string indicating the type of sequence ('DNA', 'RNA', or 'PROTEIN').
If not provided, the type is autoresolved.}

\item{evalue_cutoff}{A numeric value for the e-value cutoff in the search, default is 100.}

\item{identity_cutoff}{A numeric value for the identity cutoff in the search, default is 0.95.}
}
\value{
An object of class 'SequenceOperator' representing the sequence operator.
}
\description{
Constructs a SequenceOperator object for use in sequence-based searches within the RCSB PDB.
This operator allows specifying a sequence, its type, and cutoffs for e-value and identity.
}
