% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacetime.R
\name{rSPDE.Ast}
\alias{rSPDE.Ast}
\title{Observation matrix for space-time models}
\usage{
rSPDE.Ast(
  mesh_space = NULL,
  space_loc = NULL,
  mesh_time = NULL,
  time_loc = NULL,
  graph = NULL,
  obs.s = NULL,
  obs.t = NULL
)
}
\arguments{
\item{mesh_space}{mesh object for models on 1d or 2d domains}

\item{space_loc}{mesh locations for models on 1d domains}

\item{mesh_time}{mesh object for time discretization}

\item{time_loc}{mesh locations for time discretization}

\item{graph}{MetricGraph object for models on metric graphs}

\item{obs.s}{spatial locations of observations}

\item{obs.t}{time points for observations}
}
\value{
Observation matrix linking observation locations to mesh nodes
}
\description{
Observation matrix for space-time models
}
\examples{
s <- seq(from = 0, to = 20, length.out = 11)
t <- seq(from = 0, to = 20, length.out = 5)
n.obs <- 10
obs.loc <- data.frame(x = max(s)*runif(n.obs), 
t = max(t)*runif(n.obs))
A <- rSPDE.Ast(space_loc = s,time_loc = t, 
               obs.s = obs.loc$x, obs.t = obs.loc$t)
}
