% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_KOMs.R
\name{get_KOMs}
\alias{get_KOMs}
\title{Get KOMs/QOMs/CRs of an athlete}
\usage{
get_KOMs(id, stoken)
}
\arguments{
\item{id}{string of athlete id}

\item{stoken}{A \code{\link[httr]{config}} object created using the \code{\link{strava_oauth}} function}
}
\value{
Data from an API request.
}
\description{
Get KOMs/QOMs/CRs of an athlete
}
\details{
Requires authentication stoken using the \code{\link{strava_oauth}} function and a user-created API on the strava website.
}
\examples{
\dontrun{
# create authentication token
# requires user created app name, id, and secret from Strava website
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, 
	app_secret, cache = TRUE))

get_KOMs('2837007', stoken)
}
}
\concept{token}
