% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry_features.R
\name{geometry_features}
\alias{geometry_features}
\title{Geometry features of Neighboring Points.}
\usage{
geometry_features(
  cloud,
  method,
  radius,
  k,
  max_neighbour,
  distance = "euclidean",
  target = FALSE,
  threads = 1L,
  verbose = FALSE,
  progress = TRUE,
  ...
)
}
\arguments{
\item{cloud}{A \code{data.table} with *XYZ* coordinates in the first three columns.}

\item{method}{A character string specifying the method to estimate the neighbors. It most be one of \code{"radius_search"} or \code{"knn"}.}

\item{radius}{A \code{numeric} vector representing the radius for search to consider. This needs be used if \code{method = "radius_search"}.}

\item{k}{An \code{integer} vector representing the number of neighbors to consider. This needs be used if \code{method = "knn"}.}

\item{max_neighbour}{An \code{integer} specifying the maximum number of points to look around each query point for a given radius. This needs be used if \code{method = "radius_search"}.}

\item{distance}{Type of distance to calculate. \code{"euclidean"} as default. Look \code{hnsw_knn} for more options.}

\item{target}{Logic. If \code{TRUE}, it consider the each target point for the calculations of geometry features.}

\item{threads}{An \code{integer} specifying the number of threads to use for parallel processing. Experiment to see what works best for your data on your hardware.}

\item{verbose}{If \code{TRUE}, log messages to the console.}

\item{progress}{If \code{TRUE}, log a progress bar when \code{verbose = TRUE}. Tracking progress could cause a small overhead.}

\item{...}{Arguments passed to \code{hnsw_build} and \code{hnsw_search}.}
}
\value{
A \code{array} describing the point of the \code{cloud} in rows,
the relative eigenvalues in columns, and the \code{radius} or \code{k} per slide.
If \code{method = "radius_search"}, it add in the first column the number of
neighboring points.
}
\description{
Estimate geometry features of neighboring points in a cloud.
}
\details{
The function returns the geometry features of the neighboring points
of a given point in \code{cloud}. Geometry features are represented by the
relative values of the eigenvalues derived from a covariance matrix of the
neighboring points. Geometry features are not estimated on target points
with less than 3 neighboring points.
}
\examples{
#Create cloud
example <- data.table(X = runif(200, min=0, max=10),
                      Y = runif(200, min=0, max=10),
                      Z = runif(200, min=0, max=10))


#Using knn method with two different k
k_test <- c(5, 10)
geometry_features(example, method = "knn", k = k_test)

#Using radius search method with two different radius
radius_test <- c(3, 4)
geometry_features(example, method = "radius_search", radius = radius_test, max_neighbour = 200)

}
\author{
J. Antonio Guzmán Q.
}
