% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reticulate.R
\name{conda-tools}
\alias{conda-tools}
\alias{conda_install}
\alias{conda_python}
\title{Conda install function (modified from reticulate)}
\usage{
conda_install(envname = NULL, packages, forge = FALSE, pip = FALSE,
  pip_ignore_installed = TRUE, conda = "auto", python_version = NULL,
  channel = NULL, ...)

conda_python(envname = NULL, conda = "auto")
}
\arguments{
\item{envname}{Name of conda environment}

\item{packages}{Character vector with package names to install or remove.}

\item{forge}{Include the [Conda Forge](https://conda-forge.org/) repository.}

\item{pip}{`TRUE` to use pip (defaults to `FALSE`)}

\item{pip_ignore_installed}{Ignore installed versions when using pip. This is `TRUE` by default
so that specific package versions can be installed even if they are downgrades. The `FALSE`
option is useful for situations where you don't want a pip install to attempt an overwrite
of a conda binary package (e.g. SciPy on Windows which is very difficult to install via
pip due to compilation requirements).}

\item{conda}{Path to conda executable (or "auto" to find conda using the
PATH and other conventional install locations).}

\item{channel}{conda channel for pytorch}

\item{...}{Optional arguments, reserved for future expansion.}
}
\value{
`conda_list()` returns a data frame with the names and paths to the
  respective python binaries of available environments. `conda_create()`
  returns the Path to the python binary of the created environment.
  `conda_binary()` returns the location of the main conda binary or `NULL`
  if none can be found.
}
\description{
R functions for managing Python [conda
environments](https://conda.io/docs/user-guide/tasks/manage-environments.html).
}
\keyword{internal}
