% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivotr.R
\name{summary.pivotr}
\alias{summary.pivotr}
\title{Summary method for pivotr}
\usage{
\method{summary}{pivotr}(object, perc = FALSE, dec = 3, chi2 = FALSE,
  shiny = FALSE, ...)
}
\arguments{
\item{object}{Return value from \code{\link{pivotr}}}

\item{perc}{Display numbers as percentages (TRUE or FALSE)}

\item{dec}{Number of decimals to show}

\item{chi2}{If TRUE calculate the chi-square statistic for the (pivot) table}

\item{shiny}{Did the function call originate inside a shiny app}

\item{...}{further arguments passed to or from other methods}
}
\description{
Summary method for pivotr
}
\details{
See \url{https://radiant-rstats.github.io/docs/data/pivotr.html} for an example in Radiant
}
\examples{
pivotr(diamonds, cvars = "cut") \%>\% summary(chi2 = TRUE)
pivotr(diamonds, cvars = "cut", tabsort = "desc(n_obs)") \%>\% summary()
pivotr(diamonds, cvars = "cut", tabfilt = "n_obs > 700") \%>\% summary()
pivotr(diamonds, cvars = "cut:clarity", nvar = "price") \%>\% summary()

}
\seealso{
\code{\link{pivotr}} to create the pivot-table using dplyr
}
