% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radiant.R
\name{pfun}
\alias{pfun}
\alias{psum}
\alias{pmean}
\alias{pmedian}
\alias{psd}
\alias{pvar}
\alias{pcv}
\alias{pp01}
\alias{pp025}
\alias{pp05}
\alias{pp10}
\alias{pp25}
\alias{pp75}
\alias{pp95}
\alias{pp975}
\alias{pp99}
\title{Summarize a set of numeric vectors per row}
\usage{
pfun(..., fun, na.rm = TRUE)

psum(..., na.rm = TRUE)

pmean(..., na.rm = TRUE)

pmedian(..., na.rm = TRUE)

psd(..., na.rm = TRUE)

pvar(..., na.rm = TRUE)

pcv(..., na.rm = TRUE)

pp01(..., na.rm = TRUE)

pp025(..., na.rm = TRUE)

pp05(..., na.rm = TRUE)

pp10(..., na.rm = TRUE)

pp25(..., na.rm = TRUE)

pp75(..., na.rm = TRUE)

pp95(..., na.rm = TRUE)

pp975(..., na.rm = TRUE)

pp99(..., na.rm = TRUE)
}
\arguments{
\item{...}{Numeric vectors of the same length}

\item{fun}{Function to apply}

\item{na.rm}{a logical indicating whether missing values should be removed.}
}
\value{
A vector of 'parallel' summaries of the argument vectors.
}
\description{
Summarize a set of numeric vectors per row
}
\details{
Calculate summary statistics of the input vectors per row (or 'parallel')
}
\examples{
pfun(1:10, fun = mean)
psum(1:10, 10:1)
}
\seealso{
See also \code{\link{pmin}} and \code{\link{pmax}}
}
