% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pmap.R
\name{plot.pmap}
\alias{plot.pmap}
\title{Plot method for the pmap function}
\usage{
\method{plot}{pmap}(x, pmap_plot = "", pmap_scaling = 2.1,
  pmap_fontsz = 1.3, ...)
}
\arguments{
\item{x}{Return value from \code{\link{pmap}}}

\item{pmap_plot}{Components to include in the plot ("brand", "attr"). If data on preferences is available use "pref" to add preference arrows to the plot}

\item{pmap_scaling}{Arrow scaling in the brand map}

\item{pmap_fontsz}{Font size to use in plots}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the pmap function
}
\details{
See \url{http://mostly-harmless.github.io/radiant/marketing/pmap.html} for an example in Radiant
}
\examples{
result <- pmap("computer","Brand","HighEnd:Business")
plot(result, pmap_plot = "brand")
plot(result, pmap_plot = c("brand","attr"))
plot(result, pmap_plot = c("brand","attr"))
plot(result, pmap_scaling = 1, pmap_plot = c("brand","attr"))
result <- pmap("computer","Brand","HighEnd:Dated",
              pmap_pref = c("Innovative","Business"))
plot(result, pmap_plot = c("brand","attr","pref"))
}
\seealso{
\code{\link{mds}} to calculate results

\code{\link{summary.mds}} to plot results
}

