% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/glm_reg.R
\name{predict.glm_reg}
\alias{predict.glm_reg}
\title{Predict method for glm}
\usage{
\method{predict}{glm_reg}(object, glm_predict_cmd = "",
  glm_predict_data = "", ...)
}
\arguments{
\item{object}{Return value from \code{\link{regression}}}

\item{glm_predict_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable use a `,` (e.g., `pclass = levels(pclass), age = seq(0,100,20)`)}

\item{glm_predict_data}{Provide the name of a dataframe to generate predictions (e.g., "titanic"). The dataset must contain all columns used in the estimation}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for glm
}
\details{
See \url{http://mostly-harmless.github.io/radiant/quant/glm_reg} for an example in Radiant
}
\examples{
result <- glm_reg("titanic", "survived", c("pclass","sex"), glm_levels = "Yes")
pred <- predict(result, glm_predict_cmd = "pclass = levels(pclass)")
str(pred)
names(pred)
predict(result, glm_predict_cmd = "sex = c('male','female')")
}
\seealso{
\code{\link{glm_reg}} to generate the result

\code{\link{summary.glm_reg}} to summarize results

\code{\link{plot.glm_reg}} to plot results
}

