% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dk_activity.R
\name{dk_activity}
\alias{dk_activity}
\title{Time for a radionuclide to decay to a target activity.}
\usage{
dk_activity(A0, half_life, target)
}
\arguments{
\item{A0}{The original activity, or related parameter.}

\item{half_life, }{Half-life. Units are arbitrary, but must match time past.}

\item{target}{The target activity.}
}
\value{
time, in same units as half-life, to decay to target activity.
}
\description{
Calculate time for a radionuclide to decay to a target activity.
}
\examples{
\donttest{
# How long does it take for original activity of 10000 Bq to decay to 2500 Bq
# if half-life is 5 minutes?
# (All time units are consistent, so answer will be in minutes)
dk_activity(A0 = 10000, half_life = 5, target = 2500)
}
}
\seealso{
Other decay corrections: \code{\link{dk_cf}},
  \code{\link{dk_correct}},
  \code{\link{dk_pct_to_num_half_life}},
  \code{\link{dk_reverse}}, \code{\link{dk_time}}
}
\concept{decay corrections}
