% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_import.R
\name{img_data_to_3D_mat}
\alias{img_data_to_3D_mat}
\title{Convert image data to 3D matrix of intensities}
\usage{
img_data_to_3D_mat(img_data, coord_extra_dim)
}
\arguments{
\item{img_data}{Image data returned by e.g. \code{\link{read_dicom}} or \code{\link{read_nifti1}}}

\item{coord_extra_dim}{Coordinates in extra dimensions (beyond 3) that define the
particular 3D image of interest. Not applicable for DICOM; pass NULL in that case.}
}
\value{
3D array of intensities where third dimension is slice
}
\description{
Convert image data to 3D matrix of intensities
}
\examples{
img_data_to_3D_mat(radtools::sample_nifti_img)
\dontrun{img_data_to_3D_mat(nifti_data_4D, coord_extra_dim = 10)}
}
