% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicit.R
\name{construct_implicit_grid_structure}
\alias{construct_implicit_grid_structure}
\title{Structure of implicit numerical integration grid}
\usage{
construct_implicit_grid_structure(tenors, M, S0, K, c, sigma,
  structure_constant, std_devs_width, min_z_width = 0)
}
\arguments{
\item{tenors}{Tenors of instruments to be treated on this grid}

\item{M}{Minimum number of timesteps on this grid}

\item{S0}{An initial stock price, for setting grid scale}

\item{K}{An instrument reference stock price, for setting grid scale}

\item{c}{A continuous stock drift rate}

\item{sigma}{Volatility of diffusion process (without jumps to default)}

\item{structure_constant}{The maximum ratio between time intervals \code{dt}
and the square of space intervals \code{dz^2}}

\item{std_devs_width}{The number of standard deviations, in \code{sigma * sqrt(T)}
units, to incorporate into the grid}

\item{min_z_width}{Minimum grid width, in log space}
}
\value{
A list with elements \describe{
  \item{\code{T}}{The maximum time for this grid}
  \item{\code{dt}}{Largest permissible timestep size}
  \item{\code{dz}}{Distance between space grid points}
  \item{\code{z0}}{Center of space grid}
  \item{\code{z_width}}{Width in \eqn{z} space}
  \item{\code{half_N}}{A misnomer, actually \eqn{(N-1)/2}}
  \item{\code{N}}{The number of space points}
  \item{\code{z}}{Locations of space points}
}
}
\description{
Infer a reasonable structure for our implicit grid solver based
on the voltime, structure constant, and requested grid width
in standard deviations.
}
\details{
Generally speaking pricing will be good to about 10bp of
relative accuracy when the ratio of timesteps to voltime
(in annualized units) is over 200.

Cases with pathologically low volatility may go awry (in the sense of
 yielding ultimately inaccurate PDE solutions), as the
 {structure_constant} will force a step in {z} space much bigger
 than the width in standard deviations.
}
\seealso{
Other Implicit Grid Solver: \code{\link{find_present_value}},
  \code{\link{form_present_value_grid}},
  \code{\link{infer_conforming_time_grid}},
  \code{\link{integrate_pde}},
  \code{\link{iterate_grid_from_timestep}},
  \code{\link{take_implicit_timestep}},
  \code{\link{timestep_instruments}}
}
\concept{Implicit Grid Solver}
