% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blackscholes.R
\name{blackscholes}
\alias{blackscholes}
\title{Vectorized Black-Scholes pricing of european-exercise options}
\usage{
blackscholes(callput, S0, K, r, time, vola, default_intensity = 0,
  divrate = 0, borrow_cost = 0, dividends = NULL)
}
\arguments{
\item{callput}{1 for calls, -1 for puts}

\item{S0}{initial underlying price}

\item{K}{strike}

\item{r}{risk-free interest rate}

\item{time}{Time from \code{0} until expiration}

\item{vola}{Default-free volatility of the underlying}

\item{default_intensity}{hazard rate of underlying default}

\item{divrate}{A continuous rate for dividends and other cashflows such as foreign interest rates}

\item{borrow_cost}{A continuous rate for stock borrow costs}

\item{dividends}{A \code{data.frame} with columns \code{time}, \code{fixed},
and \code{proportional}.  Dividend size at the given \code{time} is
then expected to be equal to \code{fixed + proportional * S / S0}.  Fixed
dividends will be converted to proportional for purposes of this algorithm.}
}
\value{
A list with elements \describe{
  \item{\code{Price}}{The present value(s)}
  \item{\code{Delta}}{Sensitivity to underlying price}
  \item{\code{Vega}}{Sensitivity to volatility}
}
}
\description{
Price options according to the famous Black-Scholes formula, with the
optional addition of a jump-to-default intensity and discrete dividends.
}
\details{
Note that if the \code{default_intensity} is set larger than zero then
 put-call parity still holds.  Greeks are reduced according to cumulated default
 probability.

All inputs must either be scalars or have the same nonscalar shape.
}
\examples{
blackscholes(callput=-1, S0=100, K=90, r=0.03, time=1, # -1 is a PUT
             vola=0.5, default_intensity=0.07)
}
\seealso{
Other European Options: \code{\link{black_scholes_on_term_structures}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}

Other Equity Independent Default Intensity: \code{\link{american_implied_volatility}},
  \code{\link{american}},
  \code{\link{black_scholes_on_term_structures}},
  \code{\link{equivalent_bs_vola_to_jump}},
  \code{\link{equivalent_jump_vola_to_bs}},
  \code{\link{implied_volatilities_with_rates_struct}},
  \code{\link{implied_volatilities}},
  \code{\link{implied_volatility_with_term_struct}},
  \code{\link{implied_volatility}}
}
\concept{Equity Independent Default Intensity}
\concept{European Options}
