% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cashflows.R
\name{accelerated_coupon_value}
\alias{accelerated_coupon_value}
\title{Present value of coupons according to an acceleration schedule}
\usage{
accelerated_coupon_value(
  t,
  coupons_df,
  discount_factor_fcn,
  acceleration_t = Inf
)
}
\arguments{
\item{t}{The time toward which all coupons should be present valued}

\item{coupons_df}{A data.frame of details for each coupon.  It should have the
columns \code{payment_time} and \code{payment_size}.}

\item{discount_factor_fcn}{A function specifying how the contract says future coupons should be discounted for this instrument in case the acceleration clause is triggered}

\item{acceleration_t}{Time limit, up to which coupons will be accelerated}
}
\description{
Compute "present" value as of time t for coupons that
would otherwise have been paid up to time acceleration_t, in the
case of accelerated coupon provisions for forced conversions (or
sometimes even unforced ones).
}
\seealso{
Other Bond Coupons: 
\code{\link{coupon_value_at_exercise}()},
\code{\link{value_from_prior_coupons}()}

Other Bond Coupon Acceleration: 
\code{\link{coupon_value_at_exercise}()}
}
\concept{Bond Coupon Acceleration}
\concept{Bond Coupons}
