/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.datastream.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;

public class Attributes
implements Serializable,
Iterable<Attribute> {
    private static final long serialVersionUID = -1877629684033612201L;
    public static final String TIME_ID_ATT_NAME = "TIME_ID";
    public static final String SEQUENCE_ID_ATT_NAME = "SEQUENCE_ID";
    private final List<Attribute> attributes;
    private Attribute seq_id;
    private Attribute time_id;

    public Attributes(List<Attribute> attributes) {
        attributes.sort((a, b) -> a.getIndex() - b.getIndex());
        this.attributes = attributes;
        this.time_id = null;
        this.seq_id = null;
        for (Attribute att : this.getFullListOfAttributes()) {
            String name = att.getName();
            if (name.equals(TIME_ID_ATT_NAME)) {
                this.time_id = att;
                this.time_id.setSpecialAttribute(true);
                this.time_id.setTimeId(true);
                continue;
            }
            if (!name.equals(SEQUENCE_ID_ATT_NAME)) continue;
            this.seq_id = att;
            this.seq_id.setSpecialAttribute(true);
            this.seq_id.setSeqId(true);
        }
    }

    public Attribute getSeq_id() {
        return this.seq_id;
    }

    public Attribute getTime_id() {
        return this.time_id;
    }

    public List<Attribute> getFullListOfAttributes() {
        return this.attributes;
    }

    public int getNumberOfAttributes() {
        return this.attributes.size();
    }

    public List<Attribute> getListOfNonSpecialAttributes() {
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (Attribute att : this.getFullListOfAttributes()) {
            if (att.isSpecialAttribute()) continue;
            attributeList.add(att);
        }
        return attributeList;
    }

    public Attribute getAttributeByName(String name) {
        for (Attribute att : this.getFullListOfAttributes()) {
            if (!att.getName().equals(name)) continue;
            return att;
        }
        throw new IllegalArgumentException("Attribute " + name + " is not part of the list of Attributes");
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.attributes.iterator();
    }

    public String toString() {
        int FIXED_WIDTH = 80;
        String s = "";
        Iterator<Attribute> it = this.iterator();
        if (it.hasNext()) {
            s = s + it.next().getName();
        }
        while (it.hasNext()) {
            s = s + ", " + it.next().getName();
        }
        return WordUtils.wrap(s + "\n", 80);
    }
}

