/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.exponentialfamily;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.VariableBuilder;
import eu.amidst.core.variables.stateSpaceTypes.FiniteStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import eu.amidst.core.variables.stateSpaceTypes.SparseFiniteStateSpace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParameterVariables
implements Iterable<Variable>,
Serializable {
    private static final long serialVersionUID = 5077959998533923231L;
    private List<Variable> allParameterVariables = new ArrayList<Variable>();
    private Map<String, Integer> mapping = new ConcurrentHashMap<String, Integer>();
    int baseIndex;

    public ParameterVariables(int numberOfVariables) {
        this.baseIndex = numberOfVariables;
    }

    public Variable newNormalGamma(String name) {
        return this.newVariable(name, DistributionTypeEnum.NORMAL_GAMMA_PARAMETER, new RealStateSpace());
    }

    public Variable newGaussianParameter(String name) {
        return this.newVariable(name, DistributionTypeEnum.NORMAL_PARAMETER, new RealStateSpace());
    }

    public Variable newInverseGammaParameter(String name) {
        return this.newVariable(name, DistributionTypeEnum.INV_GAMMA_PARAMETER, new RealStateSpace());
    }

    public Variable newGammaParameter(String name) {
        return this.newVariable(name, DistributionTypeEnum.GAMMA_PARAMETER, new RealStateSpace());
    }

    public Variable newDirichletParameter(String name, int nOfStates) {
        return this.newVariable(name, DistributionTypeEnum.DIRICHLET_PARAMETER, new FiniteStateSpace(nOfStates));
    }

    public Variable newSparseDirichletParameter(String name, int nOfStates) {
        return this.newVariable(name, DistributionTypeEnum.SPARSE_DIRICHLET_PARAMETER, new SparseFiniteStateSpace(nOfStates));
    }

    public Variable newVariable(String name, DistributionTypeEnum distributionTypeEnum, StateSpaceType stateSpaceType) {
        VariableBuilder builder = new VariableBuilder();
        builder.setName(name);
        builder.setDistributionType(distributionTypeEnum);
        builder.setStateSpaceType(stateSpaceType);
        builder.setObservable(false);
        return this.newVariable(builder);
    }

    private Variable newVariable(VariableBuilder builder) {
        ParameterVariable var = new ParameterVariable(builder, this.baseIndex + this.allParameterVariables.size());
        if (this.mapping.containsKey(var.getName())) {
            throw new IllegalArgumentException("Attribute list contains duplicated names: " + var.getName());
        }
        this.mapping.put(var.getName(), var.getVarID());
        this.allParameterVariables.add(var);
        return var;
    }

    public Variable getVariableById(int varID) {
        return this.allParameterVariables.get(varID - this.baseIndex);
    }

    public Variable getVariableByName(String name) {
        Integer index = this.mapping.get(name);
        if (index == null) {
            throw new UnsupportedOperationException("Variable " + name + " is not part of the list of Variables");
        }
        return this.getVariableById(index);
    }

    public int getNumberOfVars() {
        return this.allParameterVariables.size();
    }

    @Override
    public Iterator<Variable> iterator() {
        return this.allParameterVariables.iterator();
    }

    public List<Variable> getListOfParamaterVariables() {
        return this.allParameterVariables;
    }

    private static class ParameterVariable
    implements Variable,
    Serializable {
        private static final long serialVersionUID = 4656207896676444152L;
        private String name;
        private int varID;
        private boolean observable;
        private StateSpaceType stateSpaceType;
        private DistributionTypeEnum distributionTypeEnum;
        private DistributionType distributionType;
        private int numberOfStates = -1;

        public ParameterVariable(VariableBuilder builder, int varID) {
            this.name = builder.getName();
            this.varID = varID;
            this.observable = builder.isObservable();
            this.stateSpaceType = builder.getStateSpaceType();
            this.distributionTypeEnum = builder.getDistributionType();
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.FINITE_SET) {
                this.numberOfStates = ((FiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            if (((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum() == StateSpaceTypeEnum.SPARSE_FINITE_SET) {
                this.numberOfStates = ((SparseFiniteStateSpace)this.stateSpaceType).getNumberOfStates();
            }
            this.distributionType = this.distributionTypeEnum.newDistributionType(this);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getVarID() {
            return this.varID;
        }

        @Override
        public boolean isObservable() {
            return this.observable;
        }

        @Override
        public <E extends StateSpaceType> E getStateSpaceType() {
            return (E)this.stateSpaceType;
        }

        @Override
        public DistributionTypeEnum getDistributionTypeEnum() {
            return this.distributionTypeEnum;
        }

        @Override
        public <E extends DistributionType> E getDistributionType() {
            return (E)this.distributionType;
        }

        @Override
        public boolean isInterfaceVariable() {
            return false;
        }

        @Override
        public Attribute getAttribute() {
            return null;
        }

        public void setAttribute(Attribute att) {
        }

        @Override
        public VariableBuilder getVariableBuilder() {
            return null;
        }

        @Override
        public boolean isDynamicVariable() {
            return false;
        }

        @Override
        public boolean isParameterVariable() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable var = (Variable)o;
            return this.getVarID() == var.getVarID();
        }

        @Override
        public int getNumberOfStates() {
            return this.numberOfStates;
        }

        @Override
        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

