/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.inference;

import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.models.BayesianNetwork;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;

public interface InferenceAlgorithm {
    public void runInference();

    public void setModel(BayesianNetwork var1);

    public BayesianNetwork getOriginalModel();

    public void setEvidence(Assignment var1);

    default public void setParallelMode(boolean parallelMode_) {
    }

    default public double getExpectedValue(Variable var, Function<Double, Double> function) {
        Object univariateDistribution = this.getPosterior(var);
        Random random = new Random(0L);
        int nSamples = 1000;
        double val = IntStream.range(0, nSamples).mapToDouble(i -> univariateDistribution.sample(random)).map(sample -> (Double)function.apply(sample)).sum();
        return val / (double)nSamples;
    }

    public <E extends UnivariateDistribution> E getPosterior(Variable var1);

    default public <E extends UnivariateDistribution> E getPosterior(int varID) {
        return this.getPosterior(this.getOriginalModel().getVariables().getVariableById(varID));
    }

    public double getLogProbabilityOfEvidence();

    public void setSeed(int var1);
}

