/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.inference.messagepassing;

import eu.amidst.core.exponentialfamily.EF_ConditionalDistribution;
import eu.amidst.core.exponentialfamily.EF_UnivariateDistribution;
import eu.amidst.core.exponentialfamily.MomentParameters;
import eu.amidst.core.exponentialfamily.SufficientStatistics;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public class Node
implements Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    List<Node> parents;
    List<Node> children;
    Assignment assignment;
    EF_UnivariateDistribution QDist;
    EF_ConditionalDistribution PDist;
    boolean observed = false;
    SufficientStatistics sufficientStatistics;
    boolean isDone = false;
    boolean active = true;
    Variable mainVar;
    boolean parallelActivated = true;
    Map<Variable, Node> variableToParentsNodeMap;
    Map<Node, Variable> nodeParentsToVariableMap;
    String name;

    public Node(EF_ConditionalDistribution PDist) {
        this(PDist, PDist.getVariable().getName());
    }

    public Node(EF_ConditionalDistribution PDist, String name_) {
        this.PDist = PDist;
        this.mainVar = this.PDist.getVariable();
        this.QDist = ((DistributionType)this.mainVar.getDistributionType()).newEFUnivariateDistribution();
        this.parents = new ArrayList<Node>();
        this.children = new ArrayList<Node>();
        this.observed = false;
        this.sufficientStatistics = null;
        this.name = name_;
    }

    public String getName() {
        return this.name;
    }

    public Variable getMainVariable() {
        return this.mainVar;
    }

    public boolean isParallelActivated() {
        return this.parallelActivated;
    }

    public void setParallelActivated(boolean parallelActivated) {
        this.parallelActivated = parallelActivated;
    }

    public void resetQDist(Random random) {
        this.QDist = ((EF_UnivariateDistribution)((DistributionType)this.mainVar.getDistributionType()).newEFUnivariateDistribution()).randomInitialization(random);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public void setChildren(List<Node> children) {
        this.children = children;
    }

    public List<Node> getParents() {
        return this.parents;
    }

    public void setParents(List<Node> parents) {
        this.parents = parents;
        this.variableToParentsNodeMap = new ConcurrentHashMap<Variable, Node>();
        this.nodeParentsToVariableMap = new ConcurrentHashMap<Node, Variable>();
        for (Node node : parents) {
            this.variableToParentsNodeMap.put(node.getMainVariable(), node);
            this.nodeParentsToVariableMap.put(node, node.getMainVariable());
        }
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
        if (this.assignment == null || Utils.isMissingValue(this.assignment.getValue(this.getMainVariable()))) {
            this.observed = false;
            this.sufficientStatistics = null;
        } else {
            this.observed = true;
            this.sufficientStatistics = this.QDist.getSufficientStatistics(assignment);
        }
    }

    public boolean isObserved() {
        return this.observed;
    }

    public SufficientStatistics getSufficientStatistics() {
        return this.sufficientStatistics;
    }

    public EF_ConditionalDistribution getPDist() {
        return this.PDist;
    }

    public void setPDist(EF_ConditionalDistribution PDist) {
        this.PDist = PDist;
    }

    public EF_UnivariateDistribution getQDist() {
        return this.isObserved() ? null : this.QDist;
    }

    public void setQDist(EF_UnivariateDistribution QDist) {
        this.QDist = QDist;
    }

    public MomentParameters getQMomentParameters() {
        return this.isObserved() ? (MomentParameters)((Object)this.sufficientStatistics) : this.QDist.getMomentParameters();
    }

    public Map<Variable, MomentParameters> getMomentParents() {
        ConcurrentHashMap<Variable, MomentParameters> momentParents = new ConcurrentHashMap<Variable, MomentParameters>();
        this.getPDist().getConditioningVariables().stream().forEach(var -> momentParents.put((Variable)var, this.variableToNodeParent((Variable)var).getQMomentParameters()));
        momentParents.put(this.getMainVariable(), this.getQMomentParameters());
        return momentParents;
    }

    public Variable nodeParentToVariable(Node parent) {
        return this.nodeParentsToVariableMap.get(parent);
    }

    public Node variableToNodeParent(Variable var) {
        return this.variableToParentsNodeMap.get(var);
    }

    public void setVariableToNodeParent(Variable var, Node parent) {
        this.variableToParentsNodeMap.put(var, parent);
        this.nodeParentsToVariableMap.put(parent, var);
    }

    public boolean messageDoneToParent(Variable parent) {
        if (!this.isObserved()) {
            return false;
        }
        for (Node node : this.getParents()) {
            if (!node.isActive() || node.getMainVariable().getVarID() == parent.getVarID() || node.isObserved()) continue;
            return false;
        }
        return true;
    }

    public boolean messageDoneFromParents() {
        for (Node node : this.getParents()) {
            if (!node.isActive() || node.isObserved()) continue;
            return false;
        }
        return true;
    }

    public boolean isDone() {
        return this.isDone || this.observed;
    }

    public void setIsDone(boolean isDone) {
        this.isDone = isDone;
    }
}

