/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import com.google.common.collect.Sets;
import eu.amidst.core.utils.Utils;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MissingAssignment
implements Assignment,
Serializable {
    private static final long serialVersionUID = 4107783324901370839L;
    Assignment assignment;
    Map<Variable, Boolean> missingVars = new HashMap<Variable, Boolean>();

    public MissingAssignment(Assignment assignment_) {
        this.assignment = assignment_;
    }

    public void addMissingVariable(Variable var) {
        this.missingVars.put(var, true);
    }

    @Override
    public double getValue(Variable var) {
        if (this.missingVars.containsKey(var)) {
            return Utils.missingValue();
        }
        return this.assignment.getValue(var);
    }

    @Override
    public void setValue(Variable var, double value) {
        if (this.missingVars.containsKey(var)) {
            throw new IllegalArgumentException("A missing variable can not be modified");
        }
        this.assignment.setValue(var, value);
    }

    @Override
    public Set<Variable> getVariables() {
        return Sets.union(this.assignment.getVariables(), this.missingVars.keySet());
    }
}

