/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceType;

public class VariableBuilder {
    private String name;
    private boolean observable;
    private StateSpaceType stateSpaceType;
    private DistributionTypeEnum distributionType;
    private Attribute attribute;

    public VariableBuilder() {
    }

    public VariableBuilder(Attribute att) {
        this.name = att.getName();
        this.observable = true;
        this.stateSpaceType = att.getStateSpaceType();
        switch (((StateSpaceType)att.getStateSpaceType()).getStateSpaceTypeEnum()) {
            case REAL: {
                this.distributionType = DistributionTypeEnum.NORMAL;
                break;
            }
            case FINITE_SET: {
                this.distributionType = DistributionTypeEnum.MULTINOMIAL;
                break;
            }
            case SPARSE_FINITE_SET: {
                this.distributionType = DistributionTypeEnum.SPARSE_MULTINOMIAL;
                break;
            }
            default: {
                throw new IllegalArgumentException(" The string \"" + att.getStateSpaceType() + "\" does not map to any Type.");
            }
        }
        this.attribute = att;
    }

    public VariableBuilder(Attribute att, DistributionTypeEnum typeDist) {
        this.name = att.getName();
        this.observable = true;
        this.stateSpaceType = att.getStateSpaceType();
        this.distributionType = typeDist;
        this.attribute = att;
    }

    public String getName() {
        return this.name;
    }

    public boolean isObservable() {
        return this.observable;
    }

    public StateSpaceType getStateSpaceType() {
        return this.stateSpaceType;
    }

    public DistributionTypeEnum getDistributionType() {
        return this.distributionType;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
    }

    public void setStateSpaceType(StateSpaceType stateSpaceType) {
        this.stateSpaceType = stateSpaceType;
    }

    public void setDistributionType(DistributionTypeEnum distributionType) {
        this.distributionType = distributionType;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }
}

