/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.datastream.filereaders;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.filereaders.DataFileReader;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.datastream.filereaders.DataRowMissing;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.datastream.filereaders.DynamicDataInstanceImpl;
import eu.amidst.dynamic.datastream.filereaders.NextDynamicDataInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class DynamicDataOnMemoryFromFile
implements DataOnMemory<DynamicDataInstance> {
    private DataFileReader reader;
    private Iterator<DataRow> dataRowIterator;
    private Attribute attSequenceID;
    private Attribute attTimeID;
    private NextDynamicDataInstance nextDynamicDataInstance;
    private DynamicDataInstance[] dataInstances;
    private int pointer = 0;

    public DynamicDataOnMemoryFromFile(DataFileReader reader1) {
        this.reader = reader1;
        this.dataRowIterator = this.reader.iterator();
        ArrayList<DynamicDataInstance> dataInstancesList = new ArrayList<DynamicDataInstance>();
        DataRowMissing past = new DataRowMissing();
        int timeID = 0;
        int sequenceID = 0;
        if (!this.dataRowIterator.hasNext()) {
            throw new UnsupportedOperationException("There are insufficient instances to learn a model.");
        }
        DataRow present = this.dataRowIterator.next();
        this.attSequenceID = this.reader.getAttributes().getSeq_id();
        if (this.attSequenceID != null) {
            sequenceID = (int)present.getValue(this.attSequenceID);
        }
        this.attTimeID = this.reader.getAttributes().getTime_id();
        if (this.attTimeID != null) {
            timeID = (int)present.getValue(this.attSequenceID);
        }
        this.nextDynamicDataInstance = new NextDynamicDataInstance(past, present, sequenceID, timeID);
        block6: while (this.dataRowIterator.hasNext()) {
            int option = this.attTimeID == null ? 0 : 1 + 2 * (this.attSequenceID == null ? 0 : 1);
            switch (option) {
                case 0: {
                    dataInstancesList.add(this.nextDynamicDataInstance.nextDataInstance_NoTimeID_NoSeq(this.dataRowIterator));
                    continue block6;
                }
                case 1: {
                    dataInstancesList.add(this.nextDynamicDataInstance.nextDataInstance_NoSeq(this.dataRowIterator, this.attTimeID));
                    continue block6;
                }
                case 2: {
                    dataInstancesList.add(this.nextDynamicDataInstance.nextDataInstance_NoTimeID(this.dataRowIterator, this.attSequenceID));
                    continue block6;
                }
                case 3: {
                    dataInstancesList.add(this.nextDynamicDataInstance.nextDataInstance(this.dataRowIterator, this.attSequenceID, this.attTimeID));
                    continue block6;
                }
            }
            throw new IllegalArgumentException();
        }
        this.reader.restart();
        this.dataRowIterator = this.reader.iterator();
        this.dataInstances = new DynamicDataInstanceImpl[dataInstancesList.size()];
        int counter = 0;
        Iterator iterator = dataInstancesList.iterator();
        while (iterator.hasNext()) {
            DynamicDataInstance inst;
            this.dataInstances[counter] = inst = (DynamicDataInstance)iterator.next();
            ++counter;
        }
    }

    @Override
    public int getNumberOfDataInstances() {
        return this.dataInstances.length;
    }

    @Override
    public DynamicDataInstance getDataInstance(int i) {
        return this.dataInstances[i];
    }

    @Override
    public List<DynamicDataInstance> getList() {
        return Arrays.asList(this.dataInstances);
    }

    @Override
    public Attributes getAttributes() {
        return this.reader.getAttributes();
    }

    @Override
    public Stream<DynamicDataInstance> stream() {
        return Arrays.stream(this.dataInstances);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
    }
}

