% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radab.R
\name{radab}
\alias{radab}
\title{Anti-Drug Antibody Analysis Dataset (ADAB)}
\usage{
radab(
  adsl,
  adpc,
  constants = c(D = 100, ka = 0.8, ke = 1),
  paramcd = c("R1800000", "RESULT1", "R1800001", "RESULT2", "ADASTAT1", "INDUCD1",
    "ENHANC1", "TRUNAFF1", "EMERNEG1", "EMERPOS1", "PERSADA1", "TRANADA1", "BFLAG1",
    "TIMADA1", "ADADUR1", "ADASTAT2", "INDUCD2", "ENHANC2", "EMERNEG2", "EMERPOS2",
    "BFLAG2", "TRUNAFF2"),
  param = c("Antibody titer units", "ADA interpreted per sample result",
    "Neutralizing Antibody titer units", "NAB interpreted per sample result",
    "ADA Status of a patient", "Treatment induced ADA", "Treatment enhanced ADA",
    "Treatment unaffected", "Treatment Emergent - Negative",
    "Treatment Emergent - Positive", "Persistent ADA", "Transient ADA", "Baseline",
    "Time to onset of ADA", "ADA Duration", "NAB Status of a patient",
    "Treatment induced ADA, Neutralizing Antibody",
    "Treatment enhanced ADA, Neutralizing Antibody", 
    
    "Treatment Emergent - Negative, Neutralizing Antibody",
    "Treatment Emergent - Positive, Neutralizing Antibody",
    "Baseline, Neutralizing Antibody", "Treatment unaffected, Neutralizing Antibody"),
  avalu = c("titer", "", "titer", "", "", "", "", "", "", "", "", "", "", "weeks",
    "weeks", "", "", "", "", "", "", ""),
  seed = NULL,
  na_percentage = 0,
  na_vars = list(AVAL = c(NA, 0.1)),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{adpc}{(\code{data.frame})\cr Pharmacokinetics Analysis Dataset.}

\item{constants}{(\verb{character vector})\cr Constant parameters to be used in formulas for creating analysis values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{avalu}{(\code{character})\cr Analysis value units.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADAB data \code{cadab} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radab} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating a random Anti-Drug Antibody Analysis Dataset for a given
Subject-Level Analysis Dataset and Pharmacokinetics Analysis Dataset.
}
\details{
One record per study per subject per parameter per time point: "R1800000", "RESULT1", "R1800001", "RESULT2".
}
\examples{
adsl <- radsl(N = 10, seed = 1, study_duration = 2)
adpc <- radpc(adsl, seed = 2, duration = 9 * 7)

adab <- radab(adsl, adpc, seed = 2)
adab
}
