% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/declare_ra.R
\name{obtain_condition_probabilities}
\alias{obtain_condition_probabilities}
\title{Obtain the probabilities of units being in the conditions that they are in.}
\usage{
obtain_condition_probabilities(ra_declaration, assignment)
}
\arguments{
\item{ra_declaration}{A random assignment declaration, created by \code{\link{declare_ra}}.}

\item{assignment}{A vector of random assignments, often created by \code{\link{conduct_ra}}.}
}
\description{
This function is especially useful when units have different probabilties of assignment and the analyst plans to use inverse-probability weights.
}
\examples{

# Conduct a block random assignment
block_var <- rep(c("A", "B","C"), times=c(50, 100, 200))
block_m <- rbind(c(10, 40),
                 c(30, 70),
                 c(50, 150))
declaration <- declare_ra(block_var = block_var, block_m = block_m)
Z <- conduct_ra(ra_declaration = declaration)
table(Z, block_var)

observed_probabilities <- 
   obtain_condition_probabilities(ra_declaration = declaration, assignment = Z)

# Probabilities in the control group:
table(observed_probabilities[Z == 0], block_var[Z == 0])

# Probabilities in the treatment group:
table(observed_probabilities[Z == 1], block_var[Z == 1])

}

