% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpFromCountry.R
\name{getSpFromCountry}
\alias{getSpFromCountry}
\title{Get List of species For Country}
\usage{
getSpFromCountry(country, db, useSpatialTaxonomy = FALSE)
}
\arguments{
\item{country}{character vector of country names}

\item{db}{appropriate synonyms database: squamates, birds, mammals, amphibians}

\item{useSpatialTaxonomy}{If \code{TRUE}, then the taxonomy of the original dataset is used,
if \code{FALSE}, then the 'accepted' taxonomy used in synonymy matching functions of this package
is used. See details.}
}
\value{
List of species for each country.
}
\description{
Get a list of species that are known to occur in a country, based on a 
range polygon dataset.
}
\details{
For mammals and amphibians, countries by species are derived from IUCN range polygons. For birds, range 
	polygons come from BirdLife International. For squamates, distribution data are from Reptile Database.
	If \code{useSpatialTaxonomy = FALSE}, then the taxon names associated with the spatial data are matched
	to 'accepted' taxon names. In this case, unrecognized species are dropped, and if two taxa match to the 
	same accepted taxon name, then the country data are combined. 
	For birds and squamates, as the distributional data come from the same source as the taxonomy data, there
	is only one taxonomy.

	For birds, mammals and amphibians, geographic range polygons were subset to represent the known range 
	(presence = 1), the native or reintroduced range (origin = 1 or 2), and resident, breeding and 
	non-breeding range (seasonal = 1 or 2 or 3). For squamates, this function should return only 
	native range.
}
\examples{

getSpFromCountry(c('France', 'unrecognizedCountry', 'Australia'), db = 'birds')

}
\author{
Pascal Title
}
