% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranktwosamples.R
\name{rank.two.samples}
\alias{rank.two.samples}
\title{A function for analyzing two-sample problems}
\usage{
rank.two.samples(formula, data, conf.level = 0.95,
  alternative = c("two.sided", "less", "greater"), rounds = 3,
  method = c("logit", "probit", "normal", "t.app", "permu"),
  plot.simci = FALSE, info = TRUE, wilcoxon = c("asymptotic", "exact"),
  shift.int = TRUE, nperm = 10000)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{conf.level}{A number specifying the confidence level; the default is 0.95.}

\item{alternative}{Which alternative is considered? One of "two.sided", "less", "greater".}

\item{rounds}{Value specifying the number of digits the results are rounded to.}

\item{method}{specifying the method used for calculation of the confidence intervals.
One of "logit", "probit", "normal", "t.app" and "permu".}

\item{plot.simci}{Logical, indicating whether or not confidence intervals
should be plotted}

\item{info}{Logical. info = FALSE suppresses the output of additional information
concerning e.g. the interpretation of the test results.}

\item{wilcoxon}{asymptotic or exact calculation of Wilcoxon test.}

\item{shift.int}{Logical, indicating whether or not shift effects should be considered.}

\item{nperm}{Number of permutations used, default is 10000.}
}
\description{
The rank.two.sample() function
}
\examples{
data(Muco)
Muco2 <- subset(Muco, Disease != "OAD")
twosample <- rank.two.samples(HalfTime ~ Disease, data = Muco2, 
   alternative = "greater", method = "probit", wilcoxon="exact")


}

