% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary}
\alias{summary}
\title{Summary of solutions}
\arguments{
\item{object}{\code{\link[=RapResults]{RapResults()}}, or \code{\link[=RapSolved]{RapSolved()}} object.}

\item{...}{not used.}
}
\value{
\code{data.frame}
}
\description{
Extracts summary of solutions in a \code{\link[=RapResults]{RapResults()}} or
\code{\link[=RapSolved]{RapSolved()}} object.
}
\details{
This table follows Marxan conventions
(\url{https://marxansolutions.org/}). The
columns are:
\describe{
\item{Run_Number}{The index of each solution in the object.}
\item{Status}{The status of the solution. The values in this column
correspond to outputs from the Gurobi software package (\url{https://www.gurobi.com/documentation/6.5/refman/optimization_status_codes.html}).}
\item{Score}{The objective function for the solution.}
\item{Cost}{Total cost associated with a solution.}
\item{Planning_Units}{Number of planning units selected in a solution.}
\item{Connectivity_Total}{The total amount of shared boundary length between
all planning units. All solutions in the same object should have equal
values for this column.}
\item{Connectivity_In}{The amount of shared boundary length among planning
units selected in the solution.}
\item{Connectivity_Edge}{The amount of exposed boundary length in the
solution.}
\item{Connectivity_Out}{The number of shared boundary length among planning
units not selected in the solution.}
\item{Connectivity_Fraction}{The ratio of shared boundary length in the
solution (\code{Connectivity_In}) to the total amount of boundary length
(\code{Connectivity_Edge}). This ratio is an indicator of solution quality.
Solutions with a lower ratio will have less planning units and will be more
efficient.}
}
}
\examples{
# load data
data(sim_rs)

# show summary
summary(sim_rs)
}
\seealso{
\code{\link[=RapResults]{RapResults()}}, \code{\link[=RapSolved]{RapSolved()}}.
}
