## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(fig.width=10, fig.height=10,fig.asp = 0.618, out.width = "95%", fig.align = "center", fig.dpi = 150, collapse = FALSE, comment = "#") 
#knitr::opts_chunk$set(dev = 'pdf')

## ----results='hide', message=FALSE, warning=FALSE-----------------------------
require(rasterdiv)
require(rasterVis)
require(RColorBrewer)

## -----------------------------------------------------------------------------
copNDVI <- raster::reclassify(copNDVI, cbind(252,255, NA), right=TRUE)

## -----------------------------------------------------------------------------
#Resample using raster::aggregate and a linear factor of 20
copNDVIlr <- raster::aggregate(copNDVI, fact=30)
#Set float numbers as integers to further speed up the calculation
storage.mode(copNDVIlr[]) = "integer"

## ----fig01--------------------------------------------------------------------
levelplot(copNDVIlr,layout=c(0,1,1), main="NDVI 21st of June 1999-2017 - ~150km pixel resolution")

## ----echo = T, results = 'hide', warning=FALSE, message=FALSE-----------------
#Shannon's Diversity
sha <- Shannon(copNDVIlr,window=9,na.tolerance=0.2,np=1)

#Pielou's Evenness
pie <- Pielou(copNDVIlr,window=9,na.tolerance=0.2,np=1)

#Berger-Parker's Index
ber <- BergerParker(copNDVIlr,window=9,na.tolerance=0.2,np=1)

#Parametric Rao's quadratic entropy with alpha ranging from 1 to 5
prao <- paRao(copNDVIlr, window=9, alpha=1:3, na.tolerance=0.2, dist_m="euclidean",np=1)

#Cumulative Residual Entropy
cre <- CRE(copNDVIlr,window=9,na.tolerance=0.2, np=1)

#Hill's numbers
hil <- Hill(copNDVIlr,window=9,alpha=seq(0,1,0.5),na.tolerance=0.2,np=1)

#Rényi's Index
ren <- Renyi(copNDVIlr,window=9,alpha=seq(0,1,0.5),na.tolerance=0.2,np=1)

## ----fig03--------------------------------------------------------------------
#Shannon's Diversity
levelplot(sha,main="Shannon's entropy from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,1,1), ylim=c(-60,75), margin = list(draw = TRUE))

## ----fig04--------------------------------------------------------------------
#Pielou's Evenness
levelplot(pie,main="Pielou's evenness from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,1,1), ylim=c(-60,75), margin = list(draw = TRUE))

## ----fig05--------------------------------------------------------------------
#Berger-Parker' Index
levelplot(ber,main="Berger-Parker's index from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,1,1), ylim=c(-60,75), margin = list(draw = TRUE))

## ----fig06--------------------------------------------------------------------
#Parametric Rao's quadratic Entropy
levelplot(stack(prao[[1]]),main="Parametric Rao's quadratic entropy from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,3,1), ylim=c(-60,75), margin = list(draw = TRUE))

## ----fig07--------------------------------------------------------------------
#Cumulative Residual Entropy
levelplot(cre,main="Cumulative Residual Entropy from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,1,1), ylim=c(-60,75), margin = list(draw = TRUE))

## ----fig08--------------------------------------------------------------------
#Hill's numbers (alpha=0, 0.5 and 1)
levelplot(stack(hil),main="Hill's numbers from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,3,1), ylim=c(-60,75))

## ----fig09--------------------------------------------------------------------
#Renyi' Index (alpha=0, 0.5 and 1)
levelplot(stack(ren),main="Renyi's entropy from Copernicus NDVI 5 km (9 px-side moving window)",as.table = T,layout=c(0,3,1),names.attr=paste("alpha",seq(0,1,0.5),sep=" "), ylim=c(-60,75), margin = list(draw = FALSE))

