% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-cat-functions.R
\name{abs_read_tss}
\alias{abs_read_tss}
\alias{abs_read_tss_}
\title{Extract data from an ABS time series data file}
\usage{
abs_read_tss(files, type = "tss", na.rm = TRUE)

abs_read_tss_(file, type = "tss", na.rm = na.rm)
}
\arguments{
\item{files}{Names of one or more ABS data files}

\item{type}{One of either 'tss' -- ABS Time Series Spreadsheet (the Default) or 'css' -- Data
Cube.R}

\item{na.rm}{logical. If \code{TRUE} (default), remove observations containing missing values.}
}
\value{
data frame in long format
}
\description{
This function extracts time series data from ABS data files.

This is the internal function that extracts time series data from ABS data files.
}
\examples{
  \donttest{
    ## Read specified ABS Excel time series files
    tables <- abs_cat_tables("5206.0", releases="Latest", include_urls=TRUE);
    downloaded_tables <- abs_cat_download(tables$path_zip, exdir=tempdir())
    extracted_files <- abs_cat_unzip(downloaded_tables)
    x <- abs_read_tss(extracted_files);
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>

David Mitchell <david.pk.mitchell@gmail.com>
}
\keyword{internal}
