% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-subject.R
\name{RAVESubject}
\alias{RAVESubject}
\title{Defines 'RAVE' subject class}
\description{
\code{R6} class definition
}
\seealso{
\code{\link{load_meta2}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{project}}{project instance of current subject; see
\code{\link{RAVEProject}}}

\item{\code{project_name}}{character string of project name}

\item{\code{subject_code}}{character string of subject code}

\item{\code{subject_id}}{subject ID: \code{"project/subject"}}

\item{\code{path}}{subject root path}

\item{\code{rave_path}}{'rave' directory under subject root path}

\item{\code{meta_path}}{meta data directory for current subject}

\item{\code{freesurfer_path}}{'FreeSurfer' directory for current subject. If
no path exists, values will be \code{NA}}

\item{\code{preprocess_path}}{preprocess directory under subject 'rave' path}

\item{\code{data_path}}{data directory under subject 'rave' path}

\item{\code{cache_path}}{path to 'FST' copies under subject 'data' path}

\item{\code{pipeline_path}}{path to pipeline scripts under subject's folder}

\item{\code{note_path}}{path that stores 'RAVE' related subject notes}

\item{\code{epoch_names}}{possible epoch names}

\item{\code{reference_names}}{possible reference names}

\item{\code{reference_path}}{reference path under 'rave' folder}

\item{\code{preprocess_settings}}{preprocess instance; see
\code{\link{RAVEPreprocessSettings}}}

\item{\code{blocks}}{subject experiment blocks in current project}

\item{\code{electrodes}}{all electrodes, no matter excluded or not}

\item{\code{raw_sample_rates}}{voltage sample rate}

\item{\code{power_sample_rate}}{power spectrum sample rate}

\item{\code{has_wavelet}}{whether electrodes have wavelet transforms}

\item{\code{notch_filtered}}{whether electrodes are Notch-filtered}

\item{\code{electrode_types}}{electrode signal types}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubject-print}{\code{RAVESubject$print()}}
\item \href{#method-RAVESubject-new}{\code{RAVESubject$new()}}
\item \href{#method-RAVESubject-meta_data}{\code{RAVESubject$meta_data()}}
\item \href{#method-RAVESubject-valid_electrodes}{\code{RAVESubject$valid_electrodes()}}
\item \href{#method-RAVESubject-initialize_paths}{\code{RAVESubject$initialize_paths()}}
\item \href{#method-RAVESubject-set_default}{\code{RAVESubject$set_default()}}
\item \href{#method-RAVESubject-get_default}{\code{RAVESubject$get_default()}}
\item \href{#method-RAVESubject-get_epoch}{\code{RAVESubject$get_epoch()}}
\item \href{#method-RAVESubject-get_reference}{\code{RAVESubject$get_reference()}}
\item \href{#method-RAVESubject-get_electrode_table}{\code{RAVESubject$get_electrode_table()}}
\item \href{#method-RAVESubject-get_frequency}{\code{RAVESubject$get_frequency()}}
\item \href{#method-RAVESubject-clone}{\code{RAVESubject$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-print"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-print}{}}}
\subsection{Method \code{print()}}{
override print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$new(project_name, subject_code = NULL, strict = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project_name}}{character project name}

\item{\code{subject_code}}{character subject code}

\item{\code{strict}}{whether to check if subject folders exist}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-meta_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-meta_data}{}}}
\subsection{Method \code{meta_data()}}{
get subject meta data located in \code{"meta/"} folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$meta_data(
  meta_type = c("electrodes", "frequencies", "time_points", "epoch", "references"),
  meta_name = "default"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{meta_type}}{choices are 'electrodes', 'frequencies', 'time_points',
'epoch', 'references'}

\item{\code{meta_name}}{if \code{meta_type='epoch'}, read in
\code{'epoch_<meta_name>.csv'}; if \code{meta_type='references'},
read in \code{'reference_<meta_name>.csv'}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-valid_electrodes"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-valid_electrodes}{}}}
\subsection{Method \code{valid_electrodes()}}{
get valid electrode numbers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$valid_electrodes(reference_name, refresh = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference_name}}{character, reference name, see \code{meta_name}
in \code{self$meta_data} or \code{\link{load_meta2}} when
\code{meta_type} is 'reference'}

\item{\code{refresh}}{whether to reload reference table before obtaining data,
default is false}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
integer vector of valid electrodes
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-initialize_paths"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-initialize_paths}{}}}
\subsection{Method \code{initialize_paths()}}{
create subject's directories on hard disk
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$initialize_paths(include_freesurfer = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_freesurfer}}{whether to create 'FreeSurfer' path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-set_default"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-set_default}{}}}
\subsection{Method \code{set_default()}}{
set default key-value pair for the subject, used by 'RAVE'
modules
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$set_default(key, value, namespace = "default")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{character}

\item{\code{value}}{value of the key}

\item{\code{namespace}}{file name of the note (without post-fix)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The same as \code{value}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-get_default"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-get_default}{}}}
\subsection{Method \code{get_default()}}{
get default key-value pairs for the subject, used by 'RAVE'
modules
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$get_default(
  ...,
  default_if_missing = NULL,
  simplify = TRUE,
  namespace = "default"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{single key, or a vector of character keys}

\item{\code{default_if_missing}}{default value is any key is missing}

\item{\code{simplify}}{whether to simplify the results if there is only one key
to fetch; default is \code{TRUE}}

\item{\code{namespace}}{file name of the note (without post-fix)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A named list of key-value pairs, or if one key is specified and
\code{simplify=TRUE}, then only the value will be returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-get_epoch"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-get_epoch}{}}}
\subsection{Method \code{get_epoch()}}{
check and get subject's epoch information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$get_epoch(epoch_name, as_table = FALSE, trial_starts = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epoch_name}}{epoch name, depending on the subject's meta files}

\item{\code{as_table}}{whether to convert to \code{\link{data.frame}}; default
is false}

\item{\code{trial_starts}}{the start of the trial relative to epoch time;
default is 0}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{as_table} is \code{FALSE}, then returns as
\code{\link{RAVEEpoch}} instance; otherwise returns epoch table; will
raise errors when file is missing or the epoch is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-get_reference"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-get_reference}{}}}
\subsection{Method \code{get_reference()}}{
check and get subject's reference information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$get_reference(reference_name, simplify = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{reference_name}}{reference name, depending on the subject's meta
file settings}

\item{\code{simplify}}{whether to only return the reference column}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{simplify} is true, returns a vector of reference
electrode names, otherwise returns the whole table; will
raise errors when file is missing or the reference is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-get_electrode_table"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-get_electrode_table}{}}}
\subsection{Method \code{get_electrode_table()}}{
check and get subject's electrode table with electrodes
that are load-able
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$get_electrode_table(
  electrodes,
  reference_name,
  subset = FALSE,
  simplify = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{electrodes}}{characters indicating integers such as
\code{"1-14,20-30"}, or integer vector of electrode numbers}

\item{\code{reference_name}}{see method \code{get_reference}}

\item{\code{subset}}{whether to subset the resulting data table}

\item{\code{simplify}}{whether to only return electrodes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{simplify} is true, returns a vector of electrodes
that are valid (or won't be excluded) under given reference; otherwise
returns a table. If \code{subset} is true, then the table will be
subset and only rows with electrodes to be loaded will be kept.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-get_frequency"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-get_frequency}{}}}
\subsection{Method \code{get_frequency()}}{
check and get subject's frequency table, time-frequency
decomposition is needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$get_frequency(simplify = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simplify}}{whether to simplify as vector}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{simplify} is true, returns a vector of frequencies;
otherwise returns a table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
