% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-reference.R
\name{generate_reference}
\alias{generate_reference}
\title{Generate common average reference signal for 'RAVE' subjects}
\usage{
generate_reference(subject, electrodes)
}
\arguments{
\item{subject}{subject ID or \code{\link{RAVESubject}} instance}

\item{electrodes}{electrodes to calculate the common average; these
electrodes must run through 'Wavelet' first}
}
\value{
A reference instance returned by \code{\link{new_reference}} with
signal type determined automatically.
}
\description{
To properly run this function, please install \code{ravetools}
package.
}
\details{
The goal of generating common average signals is to capture the common
movement from all the channels and remove them out from electrode
signals.

The common average signals will be stored at subject reference
directories. Two exact same copies will be stored: one in 'HDF5'
format such that the data can be read universally by other programming
languages; one in \code{\link[filearray]{filearray}} format that can be
read in R with super fast speed.
}
