% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawr.R
\name{rawr}
\alias{rawr}
\title{Automatically identify website and retrieve raw R code from it}
\usage{
rawr(url)
}
\arguments{
\item{url}{Link to an R file on supported website (github, kaggle, datacamp, tidytext)}
}
\value{
A character vector of length 1. rawr attempts to retrieve and return the raw R code it
    finds at the target url. In the case of blogdown pages, all code will be returned (not just)
    R code, and in the case of kaggle, all of R (R markdown) and Python code will be returned.
}
\description{
Automatically identify website and retrieve raw R code from it
}
\examples{
\donttest{
library(dplyr)
rawr("https://github.com/hadley/vis-eda/blob/master/travel.R")

# Same as above but provided to cat for easy viewing
rawr("https://github.com/hadley/vis-eda/blob/master/travel.R") \%>\%
  cat


# Use on multiple urls

domains <- c("https://github.com/hadley/vis-eda/blob/master/travel.R",
"https://www.datacamp.com/community/tutorials/sentiment-analysis-R",
"https://www.tidytextmining.com/sentiment.html",
"https://www.kaggle.com/vrtjso/mercari-eda-more-info-than-you-can-imagine",
"https://www.jtimm.net/2019/04/14/lexical-change-procrustes/")

domains \%>\% sapply(rawr)
}
}
