% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere_shade.R
\name{sphere_shade}
\alias{sphere_shade}
\title{sphere_shade}
\usage{
sphere_shade(heightmap, sunangle = 315, texture = "imhof1",
  normalvectors = NULL, zscale = 1, progbar = TRUE)
}
\arguments{
\item{heightmap}{A two-dimensional matrix, where each entry in the matrix is the elevation at that point. All points are assumed to be evenly spaced.}

\item{sunangle}{Default `315` (NW). The direction of the main highlight color (derived from the built-in palettes or the `create_texture` function).}

\item{texture}{Default `imhof1`. Either a square matrix indicating the spherical texture mapping, or a string indicating one 
of the built-in palettes (`imhof1`,`imhof2`,`imhof3`,`imhof4`,`desert`, `bw`, and `unicorn`).}

\item{normalvectors}{Default `NULL`. Cache of the normal vectors (from `calculate_normal` function). Supply this to speed up texture mapping.}

\item{zscale}{Default `1`. The ratio between the x and y spacing (which are assumed to be equal) and the z axis.}

\item{progbar}{Default `TRUE`. If `FALSE`, turns off progress bar.}
}
\value{
RGB array of hillshaded texture mappings.
}
\description{
Calculates local shadow map for a elevation matrix by calculating the dot 
product between light direction and the surface normal vector at that point. Each point's
intensity is proportional to the cosine of the normal ve
}
\examples{
plot_map(sphere_shade(volcano,texture="desert"))
}
