% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pending_ticks.R
\name{PendingTicks}
\alias{PendingTicks}
\alias{get_pending_ticks_data}
\alias{get_pending_ticks_values}
\alias{get_pending_ticks_value}
\alias{put_pending_ticks_values}
\alias{put_pending_ticks_value}
\alias{put_pending_ticks_data}
\title{Load and store PendingTicks NBT data}
\usage{
get_pending_ticks_data(db, x, z, dimension)

get_pending_ticks_values(db, x, z, dimension)

get_pending_ticks_value(db, x, z, dimension)

put_pending_ticks_values(db, x, z, dimension, values)

put_pending_ticks_value(db, x, z, dimension, value)

put_pending_ticks_data(db, data)
}
\arguments{
\item{db}{A bedrockdb object.}

\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{values}{A list of nbt objects}

\item{value}{An nbt object.}

\item{data}{A named-list specifying key-value pairs.}
}
\value{
\code{get_pending_ticks_data()} returns a named-list of nbt data.
\code{get_pending_ticks_values()} returns a single nbt value.
}
\description{
PendingTicks data (tag 51) holds a list of NBT values for
pending ticks.

\code{get_pending_ticks_data()} and \code{get_pending_ticks_value()} load PendingTicks
data from \code{db}. \code{get_pending_ticks_data()} will silently drop and keys not
representing PendingTicks data. \code{get_pending_ticks_value()} supports loading
only a single value. \code{get_pending_ticks_values()} is a synonym for
\code{get_pending_ticks_data()}.

\code{put_pending_ticks_values()}, \code{put_pending_ticks_value()}, and
\code{put_pending_ticks_data()} store PendingTicks data into \code{db}.
}
