% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getlanguages.R
\name{bhl_getlanguages}
\alias{bhl_getlanguages}
\title{Get a list of languages in which materials in BHL have been written.}
\usage{
bhl_getlanguages(as = "table", key = NULL, ...)
}
\arguments{
\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Get a list of languages in which materials in BHL have been written.
}
\examples{
\dontrun{
bhl_getlanguages()
bhl_getlanguages('json')
bhl_getlanguages('xml')
bhl_getlanguages('list')
}
}
