% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniprot_taxonomy.R
\name{rba_uniprot_taxonomy}
\alias{rba_uniprot_taxonomy}
\title{Get UniProt Taxonomy Nodes}
\usage{
rba_uniprot_taxonomy(
  ids,
  hierarchy = NULL,
  node_only = TRUE,
  page_size = 200,
  page_number = 1,
  ...
)
}
\arguments{
\item{ids}{(numeric) a single or a numeric vector of
\href{https://www.uniprot.org/help/taxonomic_identifier}{NCBI taxonomic
identifier(s)}}

\item{hierarchy}{Retrieve taxonomic nodes that have specific hierarchical
relation to your supplied taxonomic node. should be one of: "children",
"parent" or "siblings".}

\item{node_only}{Retrieve only the node(s) information and exclude URL links
to parents, siblings and children nodes.}

\item{page_size}{(numeric) Only when hierarchy is supplied. hierarchy
information may be very long, thus UniProt API will paginate the results,
you may use this argument to control the pagination. maximum value is 200.}

\item{page_number}{(numeric) Only when hierarchy is supplied. hierarchy
information may be very long, thus UniProt API will paginate the results,
you may use this argument to control the pagination.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a list containing your supplied nodes or their related nodes
  taxonomic information.
}
\description{
Using this function, you can retrieve taxonomic nodes information by
providing their
\href{https://www.uniprot.org/help/taxonomic_identifier}{NCBI taxonomic
  identifiers}. also, you can explicitly retrieve other nodes in relation
  to your supplied node's hierarchy in
  \href{https://www.uniprot.org/help/taxonomy}{UniProt Taxonomy database}.
}
\section{Corresponding API Resources}{

 "GET https://ebi.ac.uk/proteins/api/ids/{ids}"
 \cr "GET https://ebi.ac.uk/proteins/api/ids//id/{id}/node"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/node"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/children"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/children/node"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/parent"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/parent/node"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/siblings"
 \cr "GET https://ebi.ac.uk/proteins/api/id/{id}/siblings/node"
}

\examples{
\donttest{
rba_uniprot_taxonomy(ids = c(9606, 10090))
}
\donttest{
rba_uniprot_taxonomy(ids = 9989, hierarchy = "children")
}

}
\references{
\itemize{
  \item Andrew Nightingale, Ricardo Antunes, Emanuele Alpi, Borisas
  Bursteinas, Leonardo Gonzales, Wudong Liu, Jie Luo, Guoying Qi, Edd
  Turner, Maria Martin, The Proteins API: accessing key integrated protein
  and genome information, Nucleic Acids Research, Volume 45, Issue W1,
  3 July 2017, Pages W539–W544, https://doi.org/10.1093/nar/gkx237
  \item \href{https://www.ebi.ac.uk/proteins/api/doc/}{Proteins API
  Documentation}
  }
}
\seealso{
Other "UniProt - Taxonomy": 
\code{\link{rba_uniprot_taxonomy_lca}()},
\code{\link{rba_uniprot_taxonomy_lineage}()},
\code{\link{rba_uniprot_taxonomy_name}()},
\code{\link{rba_uniprot_taxonomy_path}()},
\code{\link{rba_uniprot_taxonomy_relationship}()}
}
\concept{"UniProt - Taxonomy"}
