% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panther.R
\name{rba_panther_info}
\alias{rba_panther_info}
\title{Get PANTHER database Information}
\usage{
rba_panther_info(what, organism_chr_loc = FALSE, families_page = 1, ...)
}
\arguments{
\item{what}{what information to retrieve? should be one of: \itemize{
\item "organisms": Retrieve supported organisms in PANTHER.
\item "datasets": Retrieve available annotation datasets.
\item "families" Retrieve available family IDs.
\item "species_tree" Retrieve the PANThER's species tree.
\item "pathways" Retrieve available pathway IDs.}}

\item{organism_chr_loc}{(Logical) (only when 'what = "organisms"')
If TRUE, only organisms with chromosome location will be returned.
If FALSE (default) every organisms will be returned.}

\item{families_page}{(Numeric) (only when 'what = "families"')
Family information is very long, so results are paginated. Use this
argument to define the page to retrieve.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
For families and species tree, a list and otherwise a data frame
  with pertinent information.
}
\description{
Using this function you can retrieve a list of available organisms,
  annotation datasets, families, and pathways which are supported in
  PANTHER.
}
\section{Corresponding API Resources}{

 "GET http://www.pantherdb.org/services/oai/pantherdb/supportedgenomes"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedannotdatasets"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedpantherfamilies"
 \cr "GET http://www.pantherdb.org/services/oai/pantherdb/supportedpantherpathways"
 \cr "GET http://pantherdb.org/services/oai/pantherdb/speciestree"
}

\examples{
\donttest{
rba_panther_info(what = "organisms")
}
\donttest{
rba_panther_info(what = "families", families_page = 4)
}

}
\references{
\itemize{
  \item Huaiyu Mi, Dustin Ebert, Anushya Muruganujan, Caitlin Mills,
  Laurent-Philippe Albou, Tremayne Mushayamaha, Paul D Thomas, PANTHER
  version 16: a revised family classification, tree-based classification
  tool, enhancer regions and extensive API, Nucleic Acids Research,
  Volume 49, Issue D1, 8 January 2021, Pages D394–D403,
  https://doi.org/10.1093/nar/gkaa1106
  \item \href{http://www.pantherdb.org/services/details.jsp}{PANTHER
  Services Details}
  \item
  \href{http://www.pantherdb.org/publications.jsp#HowToCitePANTHER}{Citations
  note on PANTHER website}
  }
}
\seealso{
Other "PANTHER": 
\code{\link{rba_panther_enrich}()},
\code{\link{rba_panther_family}()},
\code{\link{rba_panther_homolog}()},
\code{\link{rba_panther_mapping}()},
\code{\link{rba_panther_ortholog}()},
\code{\link{rba_panther_tree_grafter}()}
}
\concept{"PANTHER"}
