% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.tree.r
\name{write.tree}
\alias{write.tree}
\title{Write a newick formatted phylogenetic tree.}
\usage{
write.tree(tree = NULL, file = NULL)
}
\arguments{
\item{tree}{A \code{phylo} object, as returned from \link{read.tree}. Also 
accepts a \code{BIOM} object if it has a phylogentic tree.}

\item{file}{Filename or connection to write the newick file to (optional).}
}
\value{
If file is NULL, the newick string as a character vector. Otherwise,
        the return value from \code{writeChar}, typically invsible(NULL).
}
\description{
Write a newick formatted phylogenetic tree.
}
\examples{
    library(rbiom)
    
    infile <- system.file("extdata", "newick.tre", package = "rbiom")
    tree   <- read.tree(infile)
    newick <- write.tree(tree)

}
