% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova.R
\name{ancova}
\alias{ancova}
\title{Analysis of Covariance}
\usage{
ancova(data, vars, visits = NULL, weights = c("proportional", "equal"))
}
\arguments{
\item{data}{A \code{data.frame} containing the data to be used in the model.}

\item{vars}{A \code{vars} object as generated by \code{\link[=set_vars]{set_vars()}}. Only the \code{group},
\code{visit}, \code{outcome} and \code{covariates} elements are required. See details.}

\item{visits}{An optional character vector specifying which visits to
fit the ancova model at. If \code{NULL}, a separate ancova model will be fit to the
outcomes for each visit (as determined by \code{unique(data[[vars$visit]])}).
See details.}

\item{weights}{Character, either \code{"proportional"} (default) or \code{"equal"}. Specifies the
weighting strategy to be used for categorical covariates when calculating the lsmeans.
See details.}
}
\description{
Performs an analysis of covariance between two groups returning the estimated
"treatment effect" (i.e. the contrast between the two treatment groups) and
the least square means estimates in each group.
}
\details{
The function works as follows:
\enumerate{
\item Select the first value from \code{visits}.
\item Subset the data to only the observations that occurred on this visit.
\item Fit a linear model as  \code{vars$outcome ~ vars$group + vars$covariates}.
\item Extract the "treatment effect" & least square means for each treatment group.
\item Repeat points 2-3 for all other values in \code{visits}.
}

If no value for \code{visits} is provided then it will be set to
\code{unique(data[[vars$visit]])}.

In order to meet the formatting standards set by \code{\link[=analyse]{analyse()}} the results will be collapsed
into a single list suffixed by the visit name, e.g.:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
   trt_visit_1 = list(est = ...),
   lsm_ref_visit_1 = list(est = ...),
   lsm_alt_visit_1 = list(est = ...),
   trt_visit_2 = list(est = ...),
   lsm_ref_visit_2 = list(est = ...),
   lsm_alt_visit_2 = list(est = ...),
   ...
)
}\if{html}{\out{</div>}}

Please note that "ref" refers to the first factor level of \code{vars$group} which does not necessarily
coincide with the control arm. Analogously, "alt" refers to the second factor level of \code{vars$group}.
"trt" refers to the model contrast translating the mean difference between the second level and first level.

If you want to include interaction terms in your model this can be done
by providing them to the \code{covariates} argument of \code{\link[=set_vars]{set_vars()}}
e.g. \code{set_vars(covariates = c("sex*age"))}.
\subsection{Weighting}{

\code{"proportional"} is the default scheme that is used. This is equivalent to standardization,
i.e. the lsmeans in
each group are equal to the predicted mean outcome from the ancova model for
that group based on baseline characteristics of all subjects regardless of
their assigned group. The alternative weighting scheme, \code{"equal"}, creates hypothetical
patients by expanding out all combinations of the models categorical covariates. The
lsmeans are then calculated as the average of
the predicted mean outcome for these hypothetical patients assuming they come from each
group in turn.

In short:
\itemize{
\item \code{"proportional"} weights categorical covariates based upon their frequency of occurrence
in the data.
\item \code{"equal"} weights categorical covariates equally across all theoretical combinations.
}
}
}
\seealso{
\code{\link[=analyse]{analyse()}}

\code{\link[stats:lm]{stats::lm()}}

\code{\link[=set_vars]{set_vars()}}
}
