% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{brand_reset_ggplot}
\alias{brand_reset_ggplot}
\title{Reset ggplot2 Theme to Previous State}
\usage{
brand_reset_ggplot()
}
\value{
Invisibly returns TRUE if reset was successful, FALSE if no
previous theme was stored.
}
\description{
\code{brand_reset_ggplot} resets the ggplot2 theme to the state it was in
before brand_set_ggplot() was called.
}
\examples{
{
# Set brand theme
old_wd <- getwd()
setwd(tempdir()) # Change to temp directory for example
brand_init()
get_brand_public()
brand_set_ggplot()

# Create some plots with brand theme...

# Reset to original theme
brand_reset_ggplot()
setwd(old_wd) # Restore original working directory
}

}
