% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BtcAddresses.R
\name{PubHash2BtcAdr}
\alias{PubHash2BtcAdr}
\title{Create BTC address from public key hash}
\usage{
PubHash2BtcAdr(pubhash)
}
\arguments{
\item{pubhash}{\code{character}, the public key hash.}
}
\value{
\code{character}, the BTC address
}
\description{
This function returns the corresponding BTC address from a
hashed public key.
}
\references{
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BtcAdresses: \code{\link{BTCADR-class}},
  \code{\link{PrivKey2PubKey}}, \code{\link{PrivKey2Wif}},
  \code{\link{PubKey2PubHash}}, \code{\link{Wif2PrivKey}},
  \code{\link{base58CheckDecode}},
  \code{\link{base58CheckEncode}}, \code{\link{concatHex}},
  \code{\link{createBtcAdr}},
  \code{\link{createPrivateKey}}, \code{\link{decodeHex}},
  \code{\link{hash160}}, \code{\link{hash256}},
  \code{\link{validBtcAdr}}
}
\author{
Bernhard Pfaff
}
\concept{BtcAdresses}
