% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbwATE.R
\name{rbwATE}
\alias{rbwATE}
\title{Residual Balancing Weights for Estimating the Average Treatment Effect (ATE)}
\usage{
rbwATE(
  treatment,
  data,
  baseline_x,
  base_weights,
  max_iter = 200,
  print_level = 1,
  tol = 1e-06
)
}
\arguments{
\item{treatment}{A symbol or character string for the treatment variable.}

\item{data}{A data frame containing all variables in the model.}

\item{baseline_x}{An expression for a set of baseline confounders stored in \code{data}.}

\item{base_weights}{(Optional) A vector of base weights (or its name).}

\item{max_iter}{Maximum number of iterations for Newton's method.}

\item{print_level}{The level of printing: \describe{
\item{1}{normal: print whether the algorithm converges or not}
\item{2}{detailed: print also the maximum absolute value of the deviation between the moments
 of the reweighted data and the target moments in each iteration}
\item{3}{very detailed: print also the step length of the line searcher in iterations where
 a full Newton step is excessive.}
}}

\item{tol}{Tolerance parameter used to determine convergence.}
}
\value{
A list containing the results.
 \item{weights}{A vector of residual balancing weights.}
 \item{constraints}{A matrix of (linearly independent) residual balancing constraints}
 \item{eb_out}{Results from calling \code{\link{eb2}} function}
 \item{call}{The matched call.}
}
\description{
\code{rbwATE} is a function that produces residual balancing weights for
estimating the average treatment effect (ATE). The weights can be used to fit marginal
structural models for the effect of the treatment on the outcome.
}
\examples{
# residual balancing weights
rbwATE_fit <- rbwATE(treat, baseline_x = c(log_TotalPop, PercentOver65, log_Inc,
  PercentHispanic, PercentBlack, density,
  per_collegegrads, CanCommute), data = advertisement)

# attach residual balancing weights to data
advertisement$rbw_ate <- rbwATE_fit$weights

# fit marginal structural model
if(require(survey)){
  rbw_design <- svydesign(ids = ~ 1, weights = ~ rbw_ate, data = advertisement)
  # the outcome model includes the treatment, the square of the treatment,
  # and state-level fixed effects (Fong, Hazlett, and Imai 2018)
  msm_rbwATE <- svyglm(Cont ~ treat + I(treat^2) + factor(StFIPS), design = rbw_design)
  summary(msm_rbwATE)
}

}
