% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lens.R
\name{lens}
\alias{lens}
\title{Lens database}
\usage{
lens(type = "equidistant", max_fov = FALSE)
}
\arguments{
\item{type}{Character vector of length one. The name of the lens, see
details.}

\item{max_fov}{Logical. Use \code{TRUE} to return the maximum field of view
in degrees.}
}
\value{
If \code{max_fov} is set to \code{TRUE}, it returns a numeric vector
  of length one, which is the lens FOV in degrees. Otherwise, it returns a
  numeric vector with the coefficient of the lens function.
}
\description{
Database of lens projection functions and field of views.
}
\details{
Eventually, this will be a large database, but only the following lenses are
available at the moment:

\itemize{ \item \strong{equidistant}: standard equidistant projection
\insertCite{Schneider2009}{rcaiman}.

\item \strong{Nikon_FCE9}: Nikon FC-E9 auxiliary lens
\insertCite{Diaz2018}{rcaiman}

\item \strong{Nikkor_10.5_mm}: AF DX Fisheye-Nikkor 10.5mm f/2.8G ED
\insertCite{Pekin2009}{rcaiman}

}
}
\examples{
lens("Nikon_FCE9")
lens("Nikon_FCE9", max_fov = TRUE)
}
\references{
\insertAllCited{}
}
\seealso{
Other Lens functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_zenith_raster_coordinates}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{reproject_to_equidistant}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens functions}
