% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nts.R
\name{ntsstring}
\alias{ntsstring}
\title{Generate NTS Reference Strings}
\usage{
ntsstring(ntsid = NULL, lat = NULL, lon = NULL, bbox = NULL,
  atscale = nts.SCALE50K)
}
\arguments{
\item{ntsid}{An arbitrary number of NTS references in the form c("021", "H", "01")
or \code{list(c("021", "H", "01"), c("021", "A", "16"))} to be converted}

\item{lat}{A vector of latitude values}

\item{lon}{A vector of longitude values}

\item{bbox}{A bounding box in the form returned by sp::bbox()}

\item{atscale}{An integer value describing scale, either 1 (250k) or 2 (50k)}
}
\value{
a character vector of NTS reference strings in the form "021H01".
}
\description{
Generate NTS strings from NTS references or other arguments to generate
such a list from nts() based on arguments provided.
}
\examples{
ntsstring(c("021", "H", "01"))

library(prettymapr)
ntsstring(bbox=makebbox(45.125, -64.25, 44.875, -64.75))
}

