/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.undo.UndoableEdit;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.FlipEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.Renderer2DModel;

public class FlipAction
extends JCPAction {
    private static final long serialVersionUID = 2360209016030592684L;

    public void actionPerformed(ActionEvent e) {
        logger.info((Object)"  type  ", (Object)this.type);
        logger.debug((Object)"  source ", e.getSource());
        HashMap<IAtom, Point2d[]> atomCoordsMap = new HashMap<IAtom, Point2d[]>();
        JChemPaintModel jcpModel = this.jcpPanel.getJChemPaintModel();
        Renderer2DModel renderModel = jcpModel.getRendererModel();
        boolean horiz = "horizontal".equals(this.type);
        if (renderModel.getSelectedPart() != null && (horiz || "vertical".equals(this.type))) {
            IAtomContainer toflip = renderModel.getSelectedPart();
            Point2d center = GeometryTools.get2DCenter((IAtomContainer)toflip, (HashMap)renderModel.getRenderingCoordinates());
            for (int i = 0; i < toflip.getAtomCount(); ++i) {
                IAtom atom = toflip.getAtom(i);
                Point2d p2d = renderModel.getRenderingCoordinate(atom);
                Point2d oldCoord = new Point2d(p2d.x, p2d.y);
                if (horiz) {
                    p2d.y = 2.0 * center.y - p2d.y;
                } else {
                    p2d.x = 2.0 * center.x - p2d.x;
                }
                Point2d newCoord = p2d;
                if (oldCoord.equals((Tuple2d)newCoord)) continue;
                Point2d[] coords = new Point2d[]{newCoord, oldCoord};
                atomCoordsMap.put(atom, coords);
            }
            FlipEdit edit = new FlipEdit(atomCoordsMap);
            this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
            jcpModel.fireChange();
        }
    }
}

