/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.openscience.cdk.applications.jchempaint.JChemPaintEditorPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.jchempaint.dialogs.ValidateFrame;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.validate.BasicValidator;
import org.openscience.cdk.validate.CDKValidator;
import org.openscience.cdk.validate.IValidator;
import org.openscience.cdk.validate.ProblemMarker;

public class ValidateAction
extends JCPAction {
    private static final long serialVersionUID = -3776589605934024224L;
    ValidateFrame frame = null;

    public void actionPerformed(ActionEvent event) {
        block18: {
            logger.debug((Object)"detected validate action: ", (Object)this.type);
            if (this.type.equals("run")) {
                IChemObject object = this.getSource(event);
                if (object == null) {
                    JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
                    IChemModel model = jcpmodel.getChemModel();
                    if (model != null) {
                        this.runValidate((IChemObject)model);
                    } else {
                        System.out.println("Empty model");
                    }
                } else {
                    logger.debug((Object)"Validate called from popup menu!");
                    this.runValidate(object);
                }
            } else if (this.type.equals("clear")) {
                this.clearValidate();
            } else if (this.type.startsWith("toggle") && this.type.length() > 6) {
                String toggle = this.type.substring(6);
                try {
                    JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)event.getSource();
                    boolean newChecked = !menuItem.isSelected();
                    menuItem.setSelected(newChecked);
                    if (toggle.equals("Basic")) {
                        if (newChecked) {
                            logger.info((Object)("Turned on " + toggle));
                            JChemPaintEditorPanel.getValidatorEngine().addValidator((IValidator)new BasicValidator());
                        } else {
                            logger.info((Object)("Turned off " + toggle));
                            JChemPaintEditorPanel.getValidatorEngine().removeValidator((IValidator)new BasicValidator());
                        }
                        break block18;
                    }
                    if (toggle.equals("CDK")) {
                        if (newChecked) {
                            logger.info((Object)("Turned on " + toggle));
                            JChemPaintEditorPanel.getValidatorEngine().addValidator((IValidator)new CDKValidator());
                        } else {
                            logger.info((Object)("Turned off " + toggle));
                            JChemPaintEditorPanel.getValidatorEngine().removeValidator((IValidator)new CDKValidator());
                        }
                        break block18;
                    }
                    logger.error((Object)("Don't know what to toggle: " + toggle));
                }
                catch (ClassCastException exception) {
                    logger.error((Object)"Cannot toggle a non JCheckBoxMenuItem!");
                }
            } else {
                logger.error((Object)("Unknown command: " + this.type));
            }
        }
    }

    private void clearValidate() {
        JChemPaintModel jcpmodel = this.jcpPanel.getJChemPaintModel();
        IChemModel model = jcpmodel.getChemModel();
        IAtomContainer atoms = ChemModelManipulator.getAllInOneContainer((IChemModel)model);
        logger.info((Object)("Clearing errors on atoms: " + atoms.getAtomCount()));
        for (int i = 0; i < atoms.getAtomCount(); ++i) {
            ProblemMarker.unmark((IChemObject)atoms.getAtom(i));
        }
        jcpmodel.fireChange();
    }

    private void runValidate(IChemObject object) {
        logger.info((Object)"Running validation");
        this.clearValidate();
        if (this.jcpPanel.getJChemPaintModel() != null) {
            this.frame = new ValidateFrame(this.jcpPanel);
            this.frame.validate(object);
            this.frame.pack();
            this.frame.setVisible(true);
        }
    }
}

