/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.swing.editor.Renderer2DModelEditor;
import org.openscience.cdk.renderer.Renderer2DModel;

public class ModifyRenderOptionsDialog
extends JFrame {
    private static final long serialVersionUID = -7228371698429720333L;
    private Renderer2DModelEditor editor;
    private Renderer2DModel model;
    private JChemPaintModel jcpmodel;

    public ModifyRenderOptionsDialog(JChemPaintModel jcpmodel, Renderer2DModel model) {
        super("Modify Renderer2D Options Dialog");
        this.jcpmodel = jcpmodel;
        this.model = model;
        this.editor = new Renderer2DModelEditor((JFrame)this);
        this.createDialog();
        this.pack();
        this.setVisible(true);
    }

    private void createDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.setTitle("Rendering Options");
        this.editor.setModel(this.model);
        this.getContentPane().add("Center", (Component)this.editor);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModifyRenderOptionsDialog.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        this.getRootPane().setDefaultButton(ok);
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModifyRenderOptionsDialog.this.ApplyPressed();
            }
        });
        buttonPanel.add(apply);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ModifyRenderOptionsDialog.this.closeFrame();
            }
        });
        buttonPanel.add(cancel);
        this.getRootPane().setDefaultButton(ok);
        this.getContentPane().add("South", buttonPanel);
        this.validate();
    }

    private void ApplyPressed() {
        this.editor.applyChanges();
        this.jcpmodel.fireChange();
    }

    private void OKPressed() {
        this.ApplyPressed();
        this.closeFrame();
    }

    public void closeFrame() {
        this.dispose();
    }
}

