/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;

class Geodesic3D {
    Graphics3D g3d;
    private static final boolean DUMP = false;
    static final float halfRoot5 = (float)(0.5 * Math.sqrt(5.0));
    static final float oneFifth = 1.2566371f;
    static final float oneTenth = 0.62831855f;
    static final short[] faceVertexesIcosahedron = new short[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 7, 3, 3, 8, 4, 4, 9, 5, 5, 10, 1, 6, 1, 10, 7, 2, 6, 8, 3, 7, 9, 4, 8, 10, 5, 9, 11, 6, 10, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9};
    static final short[] neighborVertexesIcosahedron = new short[]{1, 2, 3, 4, 5, -1, 0, 5, 10, 6, 2, -1, 0, 1, 6, 7, 3, -1, 0, 2, 7, 8, 4, -1, 0, 3, 8, 9, 5, -1, 0, 4, 9, 10, 1, -1, 1, 10, 11, 7, 2, -1, 2, 6, 11, 8, 3, -1, 3, 7, 11, 9, 4, -1, 4, 8, 11, 10, 5, -1, 5, 9, 11, 6, 1, -1, 6, 7, 8, 9, 10, -1};
    static final int maxLevel = 4;
    static short[] vertexCounts;
    static short[][] neighborVertexesArrays;
    static short[][] faceVertexesArrays;
    static Vector3f[] vertexVectors;
    private static short vertexNext;
    private static Hashtable htVertex;
    private static final boolean VALIDATE = true;

    Geodesic3D(Graphics3D g3d) {
        this.g3d = g3d;
        Geodesic3D.initialize();
    }

    private static synchronized void initialize() {
        int i;
        if (vertexCounts != null) {
            return;
        }
        vertexCounts = new short[4];
        neighborVertexesArrays = new short[4][];
        faceVertexesArrays = new short[4][];
        vertexVectors = new Vector3f[12];
        Geodesic3D.vertexVectors[0] = new Vector3f(0.0f, 0.0f, halfRoot5);
        for (i = 0; i < 5; ++i) {
            Geodesic3D.vertexVectors[i + 1] = new Vector3f((float)Math.cos((float)i * 1.2566371f), (float)Math.sin((float)i * 1.2566371f), 0.5f);
            Geodesic3D.vertexVectors[i + 6] = new Vector3f((float)Math.cos((float)i * 1.2566371f + 0.62831855f), (float)Math.sin((float)i * 1.2566371f + 0.62831855f), -0.5f);
        }
        Geodesic3D.vertexVectors[11] = new Vector3f(0.0f, 0.0f, -halfRoot5);
        i = 12;
        while (--i >= 0) {
            vertexVectors[i].normalize();
        }
        Geodesic3D.faceVertexesArrays[0] = faceVertexesIcosahedron;
        Geodesic3D.neighborVertexesArrays[0] = neighborVertexesIcosahedron;
        Geodesic3D.vertexCounts[0] = 12;
        for (i = 0; i < 3; ++i) {
            Geodesic3D.quadruple(i);
        }
    }

    static int getVertexCount(int level) {
        return vertexCounts[level];
    }

    static Vector3f[] getVertexVectors() {
        return vertexVectors;
    }

    static int getFaceCount(int level) {
        return faceVertexesArrays[level].length / 3;
    }

    static int getEdgeCount(int level) {
        return Geodesic3D.getVertexCount(level) + Geodesic3D.getFaceCount(level) - 2;
    }

    static short[] getNeighborVertexes(int level) {
        return neighborVertexesArrays[level];
    }

    static short[] getFaceVertexes(int level) {
        return faceVertexesArrays[level];
    }

    private static void quadruple(int level) {
        int i;
        htVertex = new Hashtable();
        int oldVertexCount = vertexVectors.length;
        short[] oldFaceVertexes = faceVertexesArrays[level];
        int oldFaceVertexesLength = oldFaceVertexes.length;
        int oldFaceCount = oldFaceVertexesLength / 3;
        int oldEdgesCount = oldVertexCount + oldFaceCount - 2;
        int newVertexCount = oldVertexCount + oldEdgesCount;
        int newFaceCount = 4 * oldFaceCount;
        Vector3f[] newVertexVectors = new Vector3f[newVertexCount];
        System.arraycopy(vertexVectors, 0, newVertexVectors, 0, oldVertexCount);
        vertexVectors = newVertexVectors;
        short[] newFacesVertexes = new short[3 * newFaceCount];
        Geodesic3D.faceVertexesArrays[level + 1] = newFacesVertexes;
        short[] neighborVertexes = new short[6 * newVertexCount];
        Geodesic3D.neighborVertexesArrays[level + 1] = neighborVertexes;
        int i2 = neighborVertexes.length;
        while (--i2 >= 0) {
            neighborVertexes[i2] = -1;
        }
        Geodesic3D.vertexCounts[level + 1] = (short)newVertexCount;
        vertexNext = (short)oldVertexCount;
        int iFaceNew = 0;
        int i3 = 0;
        while (i3 < oldFaceVertexesLength) {
            short iA = oldFaceVertexes[i3++];
            short iB = oldFaceVertexes[i3++];
            short iC = oldFaceVertexes[i3++];
            short iAB = Geodesic3D.getVertex(iA, iB);
            short iBC = Geodesic3D.getVertex(iB, iC);
            short iCA = Geodesic3D.getVertex(iC, iA);
            newFacesVertexes[iFaceNew++] = iA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iB;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iBC;
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iAB, iA);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iAB, iCA);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iAB, iBC);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iAB, iB);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iBC, iB);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iBC, iCA);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iBC, iC);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iCA, iC);
            Geodesic3D.addNeighboringVertexes(neighborVertexes, iCA, iA);
        }
        int vertexCount = vertexVectors.length;
        if (iFaceNew != newFacesVertexes.length) {
            throw new NullPointerException();
        }
        if (vertexNext != newVertexCount) {
            throw new NullPointerException();
        }
        for (i = 0; i < 12; ++i) {
            for (int j = 0; j < 5; ++j) {
                short neighbor = neighborVertexes[i * 6 + j];
                if (neighbor < 0) {
                    throw new NullPointerException();
                }
                if (neighbor >= vertexCount) {
                    throw new NullPointerException();
                }
                if (neighborVertexes[i * 6 + 5] == -1) continue;
                throw new NullPointerException();
            }
        }
        for (i = 72; i < neighborVertexes.length; ++i) {
            short neighbor = neighborVertexes[i];
            if (neighbor < 0) {
                throw new NullPointerException();
            }
            if (neighbor < vertexCount) continue;
            throw new NullPointerException();
        }
        for (i = 0; i < newVertexCount; ++i) {
            int neighborCount = 0;
            int j = neighborVertexes.length;
            while (--j >= 0) {
                if (neighborVertexes[j] != i) continue;
                ++neighborCount;
            }
            if (i < 12 && neighborCount != 5 || i >= 12 && neighborCount != 6) {
                throw new NullPointerException();
            }
            int faceCount = 0;
            int j2 = newFacesVertexes.length;
            while (--j2 >= 0) {
                if (newFacesVertexes[j2] != i) continue;
                ++faceCount;
            }
            if ((i >= 12 || faceCount == 5) && (i < 12 || faceCount == 6)) continue;
            throw new NullPointerException();
        }
        htVertex = null;
    }

    private static void addNeighboringVertexes(short[] neighborVertexes, short v1, short v2) {
        int i;
        int iMax = i + 6;
        for (i = v1 * 6; i < iMax; ++i) {
            int j;
            if (neighborVertexes[i] == v2) {
                return;
            }
            if (neighborVertexes[i] >= 0) continue;
            neighborVertexes[i] = v2;
            int jMax = j + 6;
            for (j = v2 * 6; j < jMax; ++j) {
                if (neighborVertexes[j] == v1) {
                    return;
                }
                if (neighborVertexes[j] >= 0) continue;
                neighborVertexes[j] = v1;
                return;
            }
        }
        throw new NullPointerException();
    }

    private static short getVertex(short v1, short v2) {
        Vector3f newVertexVector;
        Integer hashKey;
        Short iv;
        if (v1 > v2) {
            short t = v1;
            v1 = v2;
            v2 = t;
        }
        if ((iv = (Short)htVertex.get(hashKey = new Integer((v1 << 16) + v2))) != null) {
            return iv;
        }
        Geodesic3D.vertexVectors[Geodesic3D.vertexNext] = newVertexVector = new Vector3f(vertexVectors[v1]);
        newVertexVector.add(vertexVectors[v2]);
        newVertexVector.scale(0.5f);
        newVertexVector.normalize();
        htVertex.put(hashKey, new Short(vertexNext));
        short s = vertexNext;
        vertexNext = (short)(s + 1);
        return s;
    }

    static boolean isNeighborVertex(short vertex1, short vertex2, int level) {
        short[] neighborVertexes = neighborVertexesArrays[level];
        int offset1 = vertex1 * 6;
        int i = offset1 + (vertex1 < 12 ? 5 : 6);
        while (--i >= offset1) {
            if (neighborVertexes[i] != vertex2) continue;
            return true;
        }
        return false;
    }
}

