/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.controller.ControllerModuleAdapter;
import org.openscience.cdk.controller.IChemModelRelay;
import org.openscience.cdk.controller.edit.OptionalUndoEdit;
import org.openscience.cdk.controller.edit.Rotate;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class RotateModule
extends ControllerModuleAdapter {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(RotateModule.class);
    private double rotationAngle;
    private boolean selectionMade = false;
    private IChemObjectSelection selection;
    private Point2d rotationCenter;
    private Vector2d[] startCoordsRelativeToRotationCenter;
    private Map<IAtom, Point2d[]> atomCoordsMap;
    private boolean rotationPerformed;

    public RotateModule(IChemModelRelay chemModelRelay) {
        super(chemModelRelay);
        this.logger.debug((Object)"constructor");
    }

    @Override
    public void mouseClickedDown(Point2d worldCoord) {
        int i;
        this.logger.debug((Object)"rotate mouseClickedDown, initializing rotation");
        this.rotationCenter = null;
        this.selection = this.chemModelRelay.getRenderer().getRenderer2DModel().getSelection();
        if (this.selection == null || !this.selection.isFilled() || this.selection.getConnectedAtomContainer() == null || this.selection.getConnectedAtomContainer().getAtomCount() == 0) {
            this.logger.debug((Object)"Nothing selected for rotation");
            this.selectionMade = false;
            return;
        }
        this.rotationAngle = 0.0;
        this.selectionMade = true;
        this.rotationPerformed = false;
        this.atomCoordsMap = new HashMap<IAtom, Point2d[]>();
        for (IAtom atom : this.selection.getConnectedAtomContainer().atoms()) {
            Point2d[] coordsforatom = new Point2d[2];
            coordsforatom[1] = atom.getPoint2d();
            this.atomCoordsMap.put(atom, coordsforatom);
        }
        IAtomContainer selectedAtoms = this.selection.getConnectedAtomContainer();
        Double upperX = null;
        Double lowerX = null;
        Double upperY = null;
        Double lowerY = null;
        for (i = 0; i < selectedAtoms.getAtomCount(); ++i) {
            double currY;
            if (upperX == null) {
                lowerX = upperX = Double.valueOf(selectedAtoms.getAtom((int)i).getPoint2d().x);
                upperY = selectedAtoms.getAtom((int)i).getPoint2d().y;
                lowerY = selectedAtoms.getAtom((int)i).getPoint2d().y;
                continue;
            }
            double currX = selectedAtoms.getAtom((int)i).getPoint2d().x;
            if (currX > upperX) {
                upperX = currX;
            }
            if (currX < lowerX) {
                lowerX = currX;
            }
            if ((currY = selectedAtoms.getAtom((int)i).getPoint2d().y) > upperY) {
                upperY = currY;
            }
            if (!(currY < lowerY)) continue;
            lowerY = currY;
        }
        this.rotationCenter = new Point2d();
        this.rotationCenter.x = (upperX + lowerX) / 2.0;
        this.rotationCenter.y = (upperY + lowerY) / 2.0;
        this.logger.debug((Object)("rotationCenter " + this.rotationCenter.x + " " + this.rotationCenter.y));
        this.startCoordsRelativeToRotationCenter = new Vector2d[selectedAtoms.getAtomCount()];
        for (i = 0; i < selectedAtoms.getAtomCount(); ++i) {
            Vector2d relativeAtomPosition = new Vector2d();
            relativeAtomPosition.sub(selectedAtoms.getAtom(i).getPoint2d(), this.rotationCenter);
            this.startCoordsRelativeToRotationCenter[i] = relativeAtomPosition;
        }
    }

    @Override
    public void mouseDrag(Point2d worldCoordFrom, Point2d worldCoordTo) {
        if (this.selectionMade) {
            double partAngle = 0.0;
            this.rotationPerformed = true;
            int quadrant = 0;
            quadrant = worldCoordFrom.x >= this.rotationCenter.x ? (worldCoordFrom.y <= this.rotationCenter.y ? 1 : 2) : (worldCoordFrom.y <= this.rotationCenter.y ? 4 : 3);
            switch (quadrant) {
                case 1: {
                    partAngle += worldCoordTo.x - worldCoordFrom.x + (worldCoordTo.y - worldCoordFrom.y);
                    break;
                }
                case 2: {
                    partAngle += worldCoordFrom.x - worldCoordTo.x + (worldCoordTo.y - worldCoordFrom.y);
                    break;
                }
                case 3: {
                    partAngle += worldCoordFrom.x - worldCoordTo.x + (worldCoordFrom.y - worldCoordTo.y);
                    break;
                }
                case 4: {
                    partAngle += worldCoordTo.x - worldCoordFrom.x + (worldCoordFrom.y - worldCoordTo.y);
                }
            }
            this.rotationAngle += partAngle;
            Rotate edit = Rotate.rotate(this.atomCoordsMap.keySet(), partAngle, this.rotationCenter);
            this.chemModelRelay.execute(OptionalUndoEdit.wrap(edit, false));
        }
    }

    @Override
    public void mouseClickedUp(Point2d worldCoord) {
        if (this.rotationPerformed && this.atomCoordsMap != null) {
            Rotate edit = Rotate.rotate(this.atomCoordsMap.keySet(), this.rotationAngle, this.rotationCenter);
            this.chemModelRelay.execute(OptionalUndoEdit.wrap(edit, true));
        }
    }

    @Override
    public void setChemModelRelay(IChemModelRelay relay) {
        this.chemModelRelay = relay;
    }

    @Override
    public String getDrawModeString() {
        return "Rotate";
    }
}

