/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.List;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.BoundsCalculator;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.ElementGroup;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.elements.RectangleElement;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;

public class BoundsGenerator
implements IGenerator<IReaction> {
    private IGeneratorParameter<Color> boundsColor = new BoundsColor();

    @Override
    public IRenderingElement generate(IReaction reaction, RendererModel model) {
        IMoleculeSet products;
        ElementGroup elementGroup = new ElementGroup();
        IMoleculeSet reactants = reaction.getReactants();
        if (reactants != null) {
            elementGroup.add(this.generate(reactants, model));
        }
        if ((products = reaction.getProducts()) != null) {
            elementGroup.add(this.generate(products, model));
        }
        return elementGroup;
    }

    @Override
    public IRenderingElement generate(IMolecule molecule, RendererModel model) {
        Rectangle2D bounds = BoundsCalculator.calculateBounds((IAtomContainer)molecule);
        return new RectangleElement(bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), this.boundsColor.getValue());
    }

    @Override
    public IRenderingElement generate(IMoleculeSet moleculeSet, RendererModel model) {
        Rectangle2D totalBounds = BoundsCalculator.calculateBounds(moleculeSet);
        return new RectangleElement(totalBounds.getMinX(), totalBounds.getMinY(), totalBounds.getMaxX(), totalBounds.getMaxY(), this.boundsColor.getValue());
    }

    @Override
    public List<IGeneratorParameter<?>> getParameters() {
        return Arrays.asList(this.boundsColor);
    }

    public static class BoundsColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.LIGHT_GRAY;
        }
    }
}

